package com.xforceplus.purchaserinvoicemanagesaas.controller;


/**
 * 发票不动产租赁对象feign客户端
 *
 * @author ultraman
 * @date 2025-11-03
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserinvoicemanagesaas.entity.InvoiceRealEstateLease;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-invoice-manage-saas")
public interface InvoiceRealEstateLeaseFeignApi {

  /**
   * 通过id查询发票不动产租赁对象
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceRealEstateLease/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增发票不动产租赁对象
   * @param invoiceRealEstateLease 发票不动产租赁对象
   * @return R
   */
  @PostMapping("/invoiceRealEstateLease/add")
  public R save(@RequestBody InvoiceRealEstateLease invoiceRealEstateLease);

  /**
   * 修改发票不动产租赁对象
   * @param invoiceRealEstateLease 发票不动产租赁对象
   * @return R
   */
  @PostMapping("/invoiceRealEstateLease/update")
  public R updateById(@RequestBody InvoiceRealEstateLease invoiceRealEstateLease);

  /**
   * 通过id删除发票不动产租赁对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceRealEstateLease/del/{id}" )
  public R removeById(@PathVariable Long id);

}