package com.xforceplus.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * operate_type
 * </p>
 *
 * @author ultraman
 * @since 2024-05-23
 */
public enum OperateType {

    _0("0", "未知"),
    _1("1", "农产品发票加计扣除操作"),
    _2("2", "发票退票操作"),
    _3("3", "发票影像删除操作"),
    _4("4", "发票删除操作"),
    _5("5", "手动验真操作"),
    _6("6", "风险发票手动跟进操作"),
    _7("7", "风险发票手动添加操作"),
    _8("8", "风险发票手动解除管控操作"),
    _9("9", "风险发票自动管控(退票)/自动解除管控(取消退票)操作"),
    _10("10", "发票取消退票操作"),
    _11("11", "下载影像"),
    _12("12", "修改扩展信息"),
    _13("13", "发票影像提交操作"),
    _14("14", "国税底账"),
    _15("15", "发票转交异常操作"),
    _16("16", "验真来源消息处理"),
    _17("17", "协同直连消息处理"),
    _18("18", "协同抽取消息处理"),
    _19("19", "协同手工回填消息处理"),
    _20("20", "影像识别消息处理"),
    _21("21", "票税助手消息处理"),
    _22("22", "接口上传消息处理"),
    _23("23", "农产品同步消息处理"),
    _24("24", "文件导入消息处理"),
    _25("25", "进项发票归集消息处理"),
    _26("26", "农产品加计扣除同步消息处理"),
    _27("27", "销项归集发票消息处理"),
    _28("28", "万科属地消息处理"),
    _29("29", "业务单签收日志消息处理"),
    _30("30", "业务单审核状态消息处理"),
    _31("31", "发票勾选操作"),
    _32("32", "发票锁定解锁操作");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    OperateType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OperateType fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            case "13":
                return _13;
            case "14":
                return _14;
            case "15":
                return _15;
            case "16":
                return _16;
            case "17":
                return _17;
            case "18":
                return _18;
            case "19":
                return _19;
            case "20":
                return _20;
            case "21":
                return _21;
            case "22":
                return _22;
            case "23":
                return _23;
            case "24":
                return _24;
            case "25":
                return _25;
            case "26":
                return _26;
            case "27":
                return _27;
            case "28":
                return _28;
            case "29":
                return _29;
            case "30":
                return _30;
            case "31":
                return _31;
            case "32":
                return _32;
            default:
                return null;
        }
    }
}
