package com.xforceplus.purchaserinvoicemanagesaas.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 发票业务信息
 * </p>
 *
 * @author ultraman
 * @since 2024-05-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceBusiness implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 组织id
   */
  private Long orgId;

  /**
   * 协同标记
   */
  private String cooperateFlag;

  /**
   * 合规状态
   */
  private String complianceStatus;

  /**
   * 退票状态
   */
  private String retreatStatus;

  /**
   * 退票备注
   */
  private String retreatRemark;

  /**
   * 锁定状态
   */
  private String hangStatus;

  /**
   * 锁定原因
   */
  private String hangRemark;

  /**
   * 签收状态
   */
  private String signForStatus;

  /**
   * 签收时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime signForTime;

  /**
   * 记账状态
   */
  private String chargeUpStatus;

  /**
   * 记账日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime chargeUpPeriod;

  /**
   * 记账单号
   */
  private String chargeUpNo;

  /**
   * 付款状态
   */
  private String paymentStatus;

  /**
   * 付款单号
   */
  private String paymentNo;

  /**
   * 付款日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paymentDate;

  /**
   * 失信状态
   */
  private String blackStatus;

  /**
   * 失信原因
   */
  private String blackRemark;

  /**
   * 进转出状态
   */
  private String turnOutStatus;

  /**
   * 进转出类型
   */
  private String turnOutType;

  /**
   * 进转出金额
   */
  private BigDecimal turnOutAmount;

  /**
   * 进转出日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime turnOutPeriod;

  /**
   * 审核状态
   */
  private String auditStatus;

  /**
   * 审核人
   */
  private String auditName;

  /**
   * 审核备注
   */
  private String auditRemark;

  /**
   * 审核时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime auditTime;

  /**
   * 被红冲不含税金额
   */
  private BigDecimal reserveAmountWithoutTax;

  /**
   * 被红冲税额
   */
  private BigDecimal reserveTaxAmount;

  /**
   * 被红冲含税金额
   */
  private BigDecimal reserveAmountWithTax;

  /**
   * 数据状态
   */
  private String dataStatus;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 购方公司ID
   */
  private Long purchaserCompanyId;

  /**
   * 购方公司编号
   */
  private String purchaserNo;

  /**
   * 发票业务类型
   */
  private String invoiceBusinessType;

  /**
   * 扩展字段1
   */
  private String ext1;

  /**
   * 扩展字段2
   */
  private String ext2;

  /**
   * 扩展字段3
   */
  private String ext3;

  /**
   * 扩展字段4
   */
  private String ext4;

  /**
   * 扩展字段5
   */
  private String ext5;

  /**
   * 扩展字段6
   */
  private String ext6;

  /**
   * 扩展字段7
   */
  private String ext7;

  /**
   * 扩展字段8
   */
  private String ext8;

  /**
   * 扩展字段9
   */
  private String ext9;

  /**
   * 扩展字段10
   */
  private String ext10;

  /**
   * 扩展字段11
   */
  private String ext11;

  /**
   * 扩展字段12
   */
  private String ext12;

  /**
   * 扩展字段13
   */
  private String ext13;

  /**
   * 扩展字段14
   */
  private String ext14;

  /**
   * 扩展字段15
   */
  private String ext15;

  /**
   * 扩展字段16
   */
  private String ext16;

  /**
   * 扩展字段17
   */
  private String ext17;

  /**
   * 扩展字段18
   */
  private String ext18;

  /**
   * 扩展字段19
   */
  private String ext19;

  /**
   * 扩展字段20
   */
  private String ext20;

  /**
   * 扩展字段21
   */
  private String ext21;

  /**
   * 扩展字段22
   */
  private String ext22;

  /**
   * 扩展字段23
   */
  private String ext23;

  /**
   * 扩展字段24
   */
  private String ext24;

  /**
   * 扩展字段25
   */
  private String ext25;

  /**
   * 销方公司ID
   */
  private Long sellerCompanyId;

  /**
   * 销方公司编号
   */
  private String sellerNo;

  /**
   * 识别状态
   */
  private String recogStatus;

  /**
   * 识别时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime recogTime;

  /**
   * 匹配状态
   */
  private String matchStatus;

  /**
   * 匹配时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime matchTime;

  /**
   * 匹配金额
   */
  private BigDecimal matchAmount;

  /**
   * 组织code
   */
  private String orgCode;

  /**
   * 业务单号
   */
  private String bizOrderNo;

  /**
   * 记账金额
   */
  private BigDecimal chargeUpAmount;

  /**
   * 付款金额
   */
  private BigDecimal paymentAmount;

  /**
   * 扫描人姓名
   */
  private String recogUserName;

  /**
   * 所属种类
   */
  private String invoiceCategory;

  /**
   * 区域
   */
  private String areaType;

  /**
   * 扫描批次号
   */
  private String recogBatchNo;

  /**
   * 是否需取消勾选
   */
  private String isCancelCheck;

  /**
   * 核销单号
   */
  private String saleConfirmNo;

  /**
   * 核销状态
   */
  private String saleConfirmStatus;

  /**
   * 核销日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime saleConfirmPeriod;

  /**
   * 记账人
   */
  private String chargeUpPerson;

  /**
   * 付款批次号
   */
  private String paymentBatchNo;

  /**
   * 付款操作人姓名
   */
  private String paymentUserName;

  /**
   * 报销状态
   */
  private String reimbursementStatus;

  /**
   * 进转出备注
   */
  private String turnOutRemark;

  /**
   * 红冲时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime redTime;

  /**
   * 红字信息表编号
   */
  private String redNotificationNo;

  /**
   * 红冲状态
   */
  private String redStatus;

  /**
   * 报账单号
   */
  private String reportNo;

  /**
   * 报账时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime reportTime;

  /**
   * 报账状态
   */
  private String reportStatus;

  /**
   * 购方外部编号
   */
  private String purchaserExternalCode;

  /**
   * 销方外部编号
   */
  private String sellerExternalCode;

  /**
   * 组织名称
   */
  private String orgName;

  /**
   * 系统来源
   */
  private String systemSource;

  /**
   * 扫描单号
   */
  private String recogOrderNo;

  /**
   * 退票时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime retreatTime;

  /**
   * 入账状态
   */
  private String entryStatus;

  /**
   * 入账时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime entryTime;

  /**
   * 入账操作人名称
   */
  private String entryUserName;

  /**
   * 入账备注
   */
  private String entryRemark;

  /**
   * 入账Tab栏状态
   */
  private String entryTabStatus;

  /**
   * 不合规类型
   */
  private String noComplianceType;

  /**
   * 扫描人id
   */
  private Long recogUserId;

  /**
   * 跟进状态
   */
  private String followUpStatus;

  /**
   * 风险处理状态
   */
  private String riskHandleStatus;

  /**
   * 跟进说明
   */
  private String followUpRemark;

  /**
   * 锁定时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime hangTime;

  /**
   * 锁定人
   */
  private String hangUser;

  /**
   * 异常日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime exceptionTime;

  /**
   * 异常创建人
   */
  private String exceptionCreateUser;

  /**
   * 重开发票号码
   */
  private String reopenInvoiceNo;

  /**
   * 重开发票代码
   */
  private String reopenInvoiceCode;

  /**
   * 业务管控状态
   */
  private String businessControlStatus;

  /**
   * 功能组别
   */
  private String functionGroup;

  /**
   * 组别更新方式
   */
  private String functionGroupWay;

  /**
   * 物流单号
   */
  private String waybillNo;

  /**
   * 扩展字段27
   */
  private String ext27;

  /**
   * 扩展字段28
   */
  private String ext28;

  /**
   * 扩展字段29
   */
  private String ext29;

  /**
   * 发票扩展字段30
   */
  private String ext30;

  /**
   * 扩展字段31
   */
  private String ext31;

  /**
   * 扩展字段32
   */
  private String ext32;

  /**
   * 扩展字段33
   */
  private String ext33;

  /**
   * 扩展字段34
   */
  private String ext34;

  /**
   * 扩展字段35
   */
  private String ext35;

  /**
   * 扩展字段36
   */
  private String ext36;

  /**
   * 扩展字段37
   */
  private String ext37;

  /**
   * 扩展字段26
   */
  private String ext26;

  /**
   * 红冲列表
   */
  private String reverseList;

  /**
   * 扫描联次
   */
  private String recogSheet;

  /**
   * 拓展字段1
   */
  private String bizTag1;

  /**
   * 拓展字段2
   */
  private String bizTag2;

  /**
   * 拓展字段3
   */
  private String bizTag3;

  /**
   * 跟进人
   */
  private String followUpUser;

  /**
   * 跟进时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime followUpTime;

  /**
   * JV/PC
   */
  private String jvPc;

  /**
   * JV/CODE
   */
  private String jvCode;

  /**
   * 门店编码
   */
  private String storeCode;

  /**
   * RMS代码
   */
  private String rmsCode;

  /**
   * 清单导入人
   */
  private String listImportUser;

  /**
   * 清单导入时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime listImportTime;

  /**
   * 市场
   */
  private String market;

  /**
   * 区域
   */
  private String area;

  /**
   * 未认证原因
   */
  private String unCertifiedReason;

  /**
   * 说明
   */
  private String unCertifiedRemark;

  /**
   * 风险发票类别
   */
  private String riskInvoiceCategory;

  /**
   * 原业务单号
   */
  private String originBizOrderNo;

  /**
   * 转交异常备注
   */
  private String sendExceptionRemark;

  /**
   * 是否重复发票
   */
  private String isRepeat;

  /**
   * 是否需要认证
   */
  private String isNeedAuth;

  /**
   * 是否转交异常
   */
  private String isSendException;

  /**
   * 退回类型
   */
  private String returnType;

  /**
   * 是否需要物流
   */
  private String needExpress;

  /**
   * 销方信息获取时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime sellerSyncTime;

  /**
   * 发票号码
   */
  private String invoiceNo;

  /**
   * 发票代码
   */
  private String invoiceCode;

  /**
   * 全电发票号码
   */
  private String allElectricInvoiceNo;

  /**
   * 退回的物流单号
   */
  private String backExpressNumber;

  /**
   * 退回联次
   */
  private String returnBatch;

  /**
   * 业务单id
   */
  private Long bizOrderId;

  /**
   * 外部发票id
   */
  private String outerInvoiceId;

  /**
   * 销方租户ID
   */
  private Long sellerTenantId;

  /**
   * 自定义编号
   */
  private String customerNo;

  /**
   * 采集方式
   */
  private String recogWay;


  /**
   * 对一关联关系 关联对象 invoiceMain
   */
    private Long businessAndInvoiceMainRelationId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("org_id", orgId);
      map.put("cooperate_flag", cooperateFlag);
      map.put("compliance_status", complianceStatus);
      map.put("retreat_status", retreatStatus);
      map.put("retreat_remark", retreatRemark);
      map.put("hang_status", hangStatus);
      map.put("hang_remark", hangRemark);
      map.put("sign_for_status", signForStatus);
      map.put("sign_for_time", BocpGenUtils.toTimestamp(signForTime));
      map.put("charge_up_status", chargeUpStatus);
      map.put("charge_up_period", BocpGenUtils.toTimestamp(chargeUpPeriod));
      map.put("charge_up_no", chargeUpNo);
      map.put("payment_status", paymentStatus);
      map.put("payment_no", paymentNo);
      map.put("payment_date", BocpGenUtils.toTimestamp(paymentDate));
      map.put("black_status", blackStatus);
      map.put("black_remark", blackRemark);
      map.put("turn_out_status", turnOutStatus);
      map.put("turn_out_type", turnOutType);
      map.put("turn_out_amount", turnOutAmount);
      map.put("turn_out_period", BocpGenUtils.toTimestamp(turnOutPeriod));
      map.put("audit_status", auditStatus);
      map.put("audit_name", auditName);
      map.put("audit_remark", auditRemark);
      map.put("audit_time", BocpGenUtils.toTimestamp(auditTime));
      map.put("reserve_amount_without_tax", reserveAmountWithoutTax);
      map.put("reserve_tax_amount", reserveTaxAmount);
      map.put("reserve_amount_with_tax", reserveAmountWithTax);
      map.put("data_status", dataStatus);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("purchaser_company_id", purchaserCompanyId);
      map.put("purchaser_no", purchaserNo);
      map.put("invoice_business_type", invoiceBusinessType);
      map.put("ext1", ext1);
      map.put("ext2", ext2);
      map.put("ext3", ext3);
      map.put("ext4", ext4);
      map.put("ext5", ext5);
      map.put("ext6", ext6);
      map.put("ext7", ext7);
      map.put("ext8", ext8);
      map.put("ext9", ext9);
      map.put("ext10", ext10);
      map.put("ext11", ext11);
      map.put("ext12", ext12);
      map.put("ext13", ext13);
      map.put("ext14", ext14);
      map.put("ext15", ext15);
      map.put("ext16", ext16);
      map.put("ext17", ext17);
      map.put("ext18", ext18);
      map.put("ext19", ext19);
      map.put("ext20", ext20);
      map.put("ext21", ext21);
      map.put("ext22", ext22);
      map.put("ext23", ext23);
      map.put("ext24", ext24);
      map.put("ext25", ext25);
      map.put("seller_company_id", sellerCompanyId);
      map.put("seller_no", sellerNo);
      map.put("recog_status", recogStatus);
      map.put("recog_time", BocpGenUtils.toTimestamp(recogTime));
      map.put("match_status", matchStatus);
      map.put("match_time", BocpGenUtils.toTimestamp(matchTime));
      map.put("match_amount", matchAmount);
      map.put("org_code", orgCode);
      map.put("biz_order_no", bizOrderNo);
      map.put("charge_up_amount", chargeUpAmount);
      map.put("payment_amount", paymentAmount);
      map.put("recog_user_name", recogUserName);
      map.put("invoice_category", invoiceCategory);
      map.put("area_type", areaType);
      map.put("recog_batch_no", recogBatchNo);
      map.put("is_cancel_check", isCancelCheck);
      map.put("sale_confirm_no", saleConfirmNo);
      map.put("sale_confirm_status", saleConfirmStatus);
      map.put("sale_confirm_period", BocpGenUtils.toTimestamp(saleConfirmPeriod));
      map.put("charge_up_person", chargeUpPerson);
      map.put("payment_batch_no", paymentBatchNo);
      map.put("payment_user_name", paymentUserName);
      map.put("reimbursement_status", reimbursementStatus);
      map.put("turn_out_remark", turnOutRemark);
      map.put("red_time", BocpGenUtils.toTimestamp(redTime));
      map.put("red_notification_no", redNotificationNo);
      map.put("red_status", redStatus);
      map.put("report_no", reportNo);
      map.put("report_time", BocpGenUtils.toTimestamp(reportTime));
      map.put("report_status", reportStatus);
      map.put("purchaser_external_code", purchaserExternalCode);
      map.put("seller_external_code", sellerExternalCode);
      map.put("org_name", orgName);
      map.put("system_source", systemSource);
      map.put("recog_order_no", recogOrderNo);
      map.put("retreat_time", BocpGenUtils.toTimestamp(retreatTime));
      map.put("entry_status", entryStatus);
      map.put("entry_time", BocpGenUtils.toTimestamp(entryTime));
      map.put("entry_user_name", entryUserName);
      map.put("entry_remark", entryRemark);
      map.put("entry_tab_status", entryTabStatus);
      map.put("no_compliance_type", noComplianceType);
      map.put("recog_user_id", recogUserId);
      map.put("follow_up_status", followUpStatus);
      map.put("risk_handle_status", riskHandleStatus);
      map.put("follow_up_remark", followUpRemark);
      map.put("hang_time", BocpGenUtils.toTimestamp(hangTime));
      map.put("hang_user", hangUser);
      map.put("exception_time", BocpGenUtils.toTimestamp(exceptionTime));
      map.put("exception_create_user", exceptionCreateUser);
      map.put("reopen_invoice_no", reopenInvoiceNo);
      map.put("reopen_invoice_code", reopenInvoiceCode);
      map.put("business_control_status", businessControlStatus);
      map.put("function_group", functionGroup);
      map.put("function_group_way", functionGroupWay);
      map.put("waybill_no", waybillNo);
      map.put("ext27", ext27);
      map.put("ext28", ext28);
      map.put("ext29", ext29);
      map.put("ext30", ext30);
      map.put("ext31", ext31);
      map.put("ext32", ext32);
      map.put("ext33", ext33);
      map.put("ext34", ext34);
      map.put("ext35", ext35);
      map.put("ext36", ext36);
      map.put("ext37", ext37);
      map.put("ext26", ext26);
      map.put("reverse_list", reverseList);
      map.put("recog_sheet", recogSheet);
      map.put("biz_tag1", bizTag1);
      map.put("biz_tag2", bizTag2);
      map.put("biz_tag3", bizTag3);
      map.put("follow_up_user", followUpUser);
      map.put("follow_up_time", BocpGenUtils.toTimestamp(followUpTime));
      map.put("jv_pc", jvPc);
      map.put("jv_code", jvCode);
      map.put("store_code", storeCode);
      map.put("rms_code", rmsCode);
      map.put("list_import_user", listImportUser);
      map.put("list_import_time", BocpGenUtils.toTimestamp(listImportTime));
      map.put("market", market);
      map.put("area", area);
      map.put("un_certified_reason", unCertifiedReason);
      map.put("un_certified_remark", unCertifiedRemark);
      map.put("risk_invoice_category", riskInvoiceCategory);
      map.put("origin_biz_order_no", originBizOrderNo);
      map.put("send_exception_remark", sendExceptionRemark);
      map.put("is_repeat", isRepeat);
      map.put("is_need_auth", isNeedAuth);
      map.put("is_send_exception", isSendException);
      map.put("return_type", returnType);
      map.put("need_express", needExpress);
      map.put("seller_sync_time", BocpGenUtils.toTimestamp(sellerSyncTime));
      map.put("invoice_no", invoiceNo);
      map.put("invoice_code", invoiceCode);
      map.put("all_electric_invoice_no", allElectricInvoiceNo);
      map.put("back_express_number", backExpressNumber);
      map.put("return_batch", returnBatch);
      map.put("biz_order_id", bizOrderId);
      map.put("outer_invoice_id", outerInvoiceId);
      map.put("seller_tenant_id", sellerTenantId);
      map.put("customer_no", customerNo);
      map.put("recog_way", recogWay);

       map.put("businessAndInvoiceMainRelation.id", businessAndInvoiceMainRelationId);
      return map;
  }

  public static InvoiceBusiness fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceBusiness entity = new InvoiceBusiness();
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("cooperate_flag")) {
      Object obj = map.get("cooperate_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCooperateFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("compliance_status")) {
      Object obj = map.get("compliance_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setComplianceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retreat_status")) {
      Object obj = map.get("retreat_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRetreatStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retreat_remark")) {
      Object obj = map.get("retreat_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRetreatRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hang_status")) {
      Object obj = map.get("hang_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHangStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hang_remark")) {
      Object obj = map.get("hang_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHangRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sign_for_status")) {
      Object obj = map.get("sign_for_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSignForStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sign_for_time")) {
      Object obj = map.get("sign_for_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSignForTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSignForTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSignForTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSignForTime(null);
      }
    }
    if(map.containsKey("charge_up_status")) {
      Object obj = map.get("charge_up_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeUpStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_up_period")) {
      Object obj = map.get("charge_up_period");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChargeUpPeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setChargeUpPeriod((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setChargeUpPeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setChargeUpPeriod(null);
      }
    }
    if(map.containsKey("charge_up_no")) {
      Object obj = map.get("charge_up_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeUpNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payment_status")) {
      Object obj = map.get("payment_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payment_no")) {
      Object obj = map.get("payment_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payment_date")) {
      Object obj = map.get("payment_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaymentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPaymentDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPaymentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaymentDate(null);
      }
    }
    if(map.containsKey("black_status")) {
      Object obj = map.get("black_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBlackStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("black_remark")) {
      Object obj = map.get("black_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBlackRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("turn_out_status")) {
      Object obj = map.get("turn_out_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTurnOutStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("turn_out_type")) {
      Object obj = map.get("turn_out_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTurnOutType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("turn_out_amount")) {
      Object obj = map.get("turn_out_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTurnOutAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTurnOutAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTurnOutAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTurnOutAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTurnOutAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("turn_out_period")) {
      Object obj = map.get("turn_out_period");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTurnOutPeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setTurnOutPeriod((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTurnOutPeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTurnOutPeriod(null);
      }
    }
    if(map.containsKey("audit_status")) {
      Object obj = map.get("audit_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuditStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("audit_name")) {
      Object obj = map.get("audit_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuditName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("audit_remark")) {
      Object obj = map.get("audit_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuditRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("audit_time")) {
      Object obj = map.get("audit_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuditTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAuditTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAuditTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuditTime(null);
      }
    }
    if(map.containsKey("reserve_amount_without_tax")) {
      Object obj = map.get("reserve_amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReserveAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReserveAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReserveAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReserveAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReserveAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("reserve_tax_amount")) {
      Object obj = map.get("reserve_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReserveTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReserveTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReserveTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReserveTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReserveTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("reserve_amount_with_tax")) {
      Object obj = map.get("reserve_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReserveAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReserveAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReserveAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReserveAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReserveAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("data_status")) {
      Object obj = map.get("data_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_company_id")) {
      Object obj = map.get("purchaser_company_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaserCompanyId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPurchaserCompanyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPurchaserCompanyId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_no")) {
      Object obj = map.get("purchaser_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_business_type")) {
      Object obj = map.get("invoice_business_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext11")) {
      Object obj = map.get("ext11");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt11((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext12")) {
      Object obj = map.get("ext12");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt12((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext13")) {
      Object obj = map.get("ext13");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt13((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext14")) {
      Object obj = map.get("ext14");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt14((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext15")) {
      Object obj = map.get("ext15");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt15((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext16")) {
      Object obj = map.get("ext16");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt16((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext17")) {
      Object obj = map.get("ext17");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt17((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext18")) {
      Object obj = map.get("ext18");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt18((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext19")) {
      Object obj = map.get("ext19");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt19((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext20")) {
      Object obj = map.get("ext20");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt20((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext21")) {
      Object obj = map.get("ext21");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt21((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext22")) {
      Object obj = map.get("ext22");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt22((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext23")) {
      Object obj = map.get("ext23");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt23((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext24")) {
      Object obj = map.get("ext24");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt24((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext25")) {
      Object obj = map.get("ext25");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt25((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_company_id")) {
      Object obj = map.get("seller_company_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSellerCompanyId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSellerCompanyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSellerCompanyId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("seller_no")) {
      Object obj = map.get("seller_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recog_status")) {
      Object obj = map.get("recog_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecogStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recog_time")) {
      Object obj = map.get("recog_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRecogTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setRecogTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRecogTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRecogTime(null);
      }
    }
    if(map.containsKey("match_status")) {
      Object obj = map.get("match_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMatchStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("match_time")) {
      Object obj = map.get("match_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMatchTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setMatchTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMatchTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setMatchTime(null);
      }
    }
    if(map.containsKey("match_amount")) {
      Object obj = map.get("match_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setMatchAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setMatchAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setMatchAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMatchAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMatchAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("org_code")) {
      Object obj = map.get("org_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("biz_order_no")) {
      Object obj = map.get("biz_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_up_amount")) {
      Object obj = map.get("charge_up_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setChargeUpAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setChargeUpAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setChargeUpAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setChargeUpAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setChargeUpAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("payment_amount")) {
      Object obj = map.get("payment_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPaymentAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPaymentAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPaymentAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPaymentAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPaymentAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("recog_user_name")) {
      Object obj = map.get("recog_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecogUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_category")) {
      Object obj = map.get("invoice_category");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("area_type")) {
      Object obj = map.get("area_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAreaType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recog_batch_no")) {
      Object obj = map.get("recog_batch_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecogBatchNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_cancel_check")) {
      Object obj = map.get("is_cancel_check");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsCancelCheck((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sale_confirm_no")) {
      Object obj = map.get("sale_confirm_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSaleConfirmNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sale_confirm_status")) {
      Object obj = map.get("sale_confirm_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSaleConfirmStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sale_confirm_period")) {
      Object obj = map.get("sale_confirm_period");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSaleConfirmPeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSaleConfirmPeriod((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSaleConfirmPeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSaleConfirmPeriod(null);
      }
    }
    if(map.containsKey("charge_up_person")) {
      Object obj = map.get("charge_up_person");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeUpPerson((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payment_batch_no")) {
      Object obj = map.get("payment_batch_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentBatchNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payment_user_name")) {
      Object obj = map.get("payment_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reimbursement_status")) {
      Object obj = map.get("reimbursement_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReimbursementStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("turn_out_remark")) {
      Object obj = map.get("turn_out_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTurnOutRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("red_time")) {
      Object obj = map.get("red_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRedTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setRedTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRedTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRedTime(null);
      }
    }
    if(map.containsKey("red_notification_no")) {
      Object obj = map.get("red_notification_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedNotificationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("red_status")) {
      Object obj = map.get("red_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("report_no")) {
      Object obj = map.get("report_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReportNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("report_time")) {
      Object obj = map.get("report_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReportTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setReportTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReportTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReportTime(null);
      }
    }
    if(map.containsKey("report_status")) {
      Object obj = map.get("report_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReportStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_external_code")) {
      Object obj = map.get("purchaser_external_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserExternalCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_external_code")) {
      Object obj = map.get("seller_external_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerExternalCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_name")) {
      Object obj = map.get("org_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("system_source")) {
      Object obj = map.get("system_source");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSystemSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recog_order_no")) {
      Object obj = map.get("recog_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecogOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retreat_time")) {
      Object obj = map.get("retreat_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRetreatTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setRetreatTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRetreatTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRetreatTime(null);
      }
    }
    if(map.containsKey("entry_status")) {
      Object obj = map.get("entry_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEntryStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("entry_time")) {
      Object obj = map.get("entry_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEntryTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setEntryTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEntryTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEntryTime(null);
      }
    }
    if(map.containsKey("entry_user_name")) {
      Object obj = map.get("entry_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEntryUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("entry_remark")) {
      Object obj = map.get("entry_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEntryRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("entry_tab_status")) {
      Object obj = map.get("entry_tab_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEntryTabStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("no_compliance_type")) {
      Object obj = map.get("no_compliance_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNoComplianceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recog_user_id")) {
      Object obj = map.get("recog_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRecogUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRecogUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRecogUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("follow_up_status")) {
      Object obj = map.get("follow_up_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFollowUpStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("risk_handle_status")) {
      Object obj = map.get("risk_handle_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRiskHandleStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("follow_up_remark")) {
      Object obj = map.get("follow_up_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFollowUpRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hang_time")) {
      Object obj = map.get("hang_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setHangTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setHangTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setHangTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setHangTime(null);
      }
    }
    if(map.containsKey("hang_user")) {
      Object obj = map.get("hang_user");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHangUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_time")) {
      Object obj = map.get("exception_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExceptionTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setExceptionTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExceptionTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setExceptionTime(null);
      }
    }
    if(map.containsKey("exception_create_user")) {
      Object obj = map.get("exception_create_user");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExceptionCreateUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reopen_invoice_no")) {
      Object obj = map.get("reopen_invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReopenInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reopen_invoice_code")) {
      Object obj = map.get("reopen_invoice_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReopenInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_control_status")) {
      Object obj = map.get("business_control_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessControlStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("function_group")) {
      Object obj = map.get("function_group");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFunctionGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("function_group_way")) {
      Object obj = map.get("function_group_way");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFunctionGroupWay((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("waybill_no")) {
      Object obj = map.get("waybill_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWaybillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext27")) {
      Object obj = map.get("ext27");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt27((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext28")) {
      Object obj = map.get("ext28");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt28((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext29")) {
      Object obj = map.get("ext29");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt29((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext30")) {
      Object obj = map.get("ext30");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt30((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext31")) {
      Object obj = map.get("ext31");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt31((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext32")) {
      Object obj = map.get("ext32");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt32((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext33")) {
      Object obj = map.get("ext33");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt33((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext34")) {
      Object obj = map.get("ext34");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt34((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext35")) {
      Object obj = map.get("ext35");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt35((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext36")) {
      Object obj = map.get("ext36");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt36((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext37")) {
      Object obj = map.get("ext37");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt37((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext26")) {
      Object obj = map.get("ext26");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt26((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reverse_list")) {
      Object obj = map.get("reverse_list");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReverseList((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recog_sheet")) {
      Object obj = map.get("recog_sheet");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecogSheet((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("biz_tag1")) {
      Object obj = map.get("biz_tag1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizTag1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("biz_tag2")) {
      Object obj = map.get("biz_tag2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizTag2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("biz_tag3")) {
      Object obj = map.get("biz_tag3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizTag3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("follow_up_user")) {
      Object obj = map.get("follow_up_user");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFollowUpUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("follow_up_time")) {
      Object obj = map.get("follow_up_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFollowUpTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setFollowUpTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFollowUpTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setFollowUpTime(null);
      }
    }
    if(map.containsKey("jv_pc")) {
      Object obj = map.get("jv_pc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJvPc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jv_code")) {
      Object obj = map.get("jv_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJvCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("store_code")) {
      Object obj = map.get("store_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rms_code")) {
      Object obj = map.get("rms_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRmsCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("list_import_user")) {
      Object obj = map.get("list_import_user");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setListImportUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("list_import_time")) {
      Object obj = map.get("list_import_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setListImportTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setListImportTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setListImportTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setListImportTime(null);
      }
    }
    if(map.containsKey("market")) {
      Object obj = map.get("market");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMarket((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("area")) {
      Object obj = map.get("area");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setArea((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("un_certified_reason")) {
      Object obj = map.get("un_certified_reason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnCertifiedReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("un_certified_remark")) {
      Object obj = map.get("un_certified_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnCertifiedRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("risk_invoice_category")) {
      Object obj = map.get("risk_invoice_category");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRiskInvoiceCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origin_biz_order_no")) {
      Object obj = map.get("origin_biz_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginBizOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("send_exception_remark")) {
      Object obj = map.get("send_exception_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSendExceptionRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_repeat")) {
      Object obj = map.get("is_repeat");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsRepeat((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_need_auth")) {
      Object obj = map.get("is_need_auth");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsNeedAuth((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_send_exception")) {
      Object obj = map.get("is_send_exception");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsSendException((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("return_type")) {
      Object obj = map.get("return_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReturnType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("need_express")) {
      Object obj = map.get("need_express");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNeedExpress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_sync_time")) {
      Object obj = map.get("seller_sync_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSellerSyncTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSellerSyncTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSellerSyncTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSellerSyncTime(null);
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("all_electric_invoice_no")) {
      Object obj = map.get("all_electric_invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAllElectricInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("back_express_number")) {
      Object obj = map.get("back_express_number");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBackExpressNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("return_batch")) {
      Object obj = map.get("return_batch");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReturnBatch((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("biz_order_id")) {
      Object obj = map.get("biz_order_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBizOrderId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBizOrderId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBizOrderId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("outer_invoice_id")) {
      Object obj = map.get("outer_invoice_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOuterInvoiceId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tenant_id")) {
      Object obj = map.get("seller_tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSellerTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSellerTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSellerTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("customer_no")) {
      Object obj = map.get("customer_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recog_way")) {
      Object obj = map.get("recog_way");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecogWay((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("businessAndInvoiceMainRelation.id")) {
        Object obj = map.get("businessAndInvoiceMainRelation.id");
      if(obj instanceof Long) {
        entity.setBusinessAndInvoiceMainRelationId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setBusinessAndInvoiceMainRelationId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrgId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrgId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("cooperate_flag")) {
      Object obj = map.get("cooperate_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCooperateFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("compliance_status")) {
      Object obj = map.get("compliance_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setComplianceStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("retreat_status")) {
      Object obj = map.get("retreat_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRetreatStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("retreat_remark")) {
      Object obj = map.get("retreat_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRetreatRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("hang_status")) {
      Object obj = map.get("hang_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHangStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("hang_remark")) {
      Object obj = map.get("hang_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHangRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sign_for_status")) {
      Object obj = map.get("sign_for_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSignForStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sign_for_time")) {
      Object obj = map.get("sign_for_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSignForTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSignForTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSignForTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSignForTime(null);
      }
    }
    if(map.containsKey("charge_up_status")) {
      Object obj = map.get("charge_up_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeUpStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("charge_up_period")) {
      Object obj = map.get("charge_up_period");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setChargeUpPeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setChargeUpPeriod((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setChargeUpPeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setChargeUpPeriod(null);
      }
    }
    if(map.containsKey("charge_up_no")) {
      Object obj = map.get("charge_up_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeUpNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payment_status")) {
      Object obj = map.get("payment_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payment_no")) {
      Object obj = map.get("payment_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payment_date")) {
      Object obj = map.get("payment_date");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPaymentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPaymentDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPaymentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPaymentDate(null);
      }
    }
    if(map.containsKey("black_status")) {
      Object obj = map.get("black_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBlackStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("black_remark")) {
      Object obj = map.get("black_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBlackRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("turn_out_status")) {
      Object obj = map.get("turn_out_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTurnOutStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("turn_out_type")) {
      Object obj = map.get("turn_out_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTurnOutType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("turn_out_amount")) {
      Object obj = map.get("turn_out_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTurnOutAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTurnOutAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTurnOutAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTurnOutAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTurnOutAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("turn_out_period")) {
      Object obj = map.get("turn_out_period");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTurnOutPeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setTurnOutPeriod((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTurnOutPeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setTurnOutPeriod(null);
      }
    }
    if(map.containsKey("audit_status")) {
      Object obj = map.get("audit_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuditStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("audit_name")) {
      Object obj = map.get("audit_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuditName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("audit_remark")) {
      Object obj = map.get("audit_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuditRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("audit_time")) {
      Object obj = map.get("audit_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAuditTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setAuditTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAuditTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setAuditTime(null);
      }
    }
    if(map.containsKey("reserve_amount_without_tax")) {
      Object obj = map.get("reserve_amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setReserveAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setReserveAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setReserveAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReserveAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setReserveAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("reserve_tax_amount")) {
      Object obj = map.get("reserve_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setReserveTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setReserveTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setReserveTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReserveTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setReserveTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("reserve_amount_with_tax")) {
      Object obj = map.get("reserve_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setReserveAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setReserveAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setReserveAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReserveAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setReserveAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("data_status")) {
      Object obj = map.get("data_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDataStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_company_id")) {
      Object obj = map.get("purchaser_company_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPurchaserCompanyId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPurchaserCompanyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPurchaserCompanyId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_no")) {
      Object obj = map.get("purchaser_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_business_type")) {
      Object obj = map.get("invoice_business_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceBusinessType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt6((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt7((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt8((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt9((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt10((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext11")) {
      Object obj = map.get("ext11");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt11((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext12")) {
      Object obj = map.get("ext12");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt12((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext13")) {
      Object obj = map.get("ext13");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt13((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext14")) {
      Object obj = map.get("ext14");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt14((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext15")) {
      Object obj = map.get("ext15");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt15((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext16")) {
      Object obj = map.get("ext16");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt16((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext17")) {
      Object obj = map.get("ext17");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt17((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext18")) {
      Object obj = map.get("ext18");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt18((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext19")) {
      Object obj = map.get("ext19");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt19((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext20")) {
      Object obj = map.get("ext20");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt20((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext21")) {
      Object obj = map.get("ext21");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt21((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext22")) {
      Object obj = map.get("ext22");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt22((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext23")) {
      Object obj = map.get("ext23");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt23((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext24")) {
      Object obj = map.get("ext24");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt24((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext25")) {
      Object obj = map.get("ext25");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt25((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_company_id")) {
      Object obj = map.get("seller_company_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSellerCompanyId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSellerCompanyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSellerCompanyId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("seller_no")) {
      Object obj = map.get("seller_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("recog_status")) {
      Object obj = map.get("recog_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecogStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("recog_time")) {
      Object obj = map.get("recog_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRecogTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setRecogTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRecogTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setRecogTime(null);
      }
    }
    if(map.containsKey("match_status")) {
      Object obj = map.get("match_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMatchStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("match_time")) {
      Object obj = map.get("match_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setMatchTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setMatchTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setMatchTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setMatchTime(null);
      }
    }
    if(map.containsKey("match_amount")) {
      Object obj = map.get("match_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setMatchAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setMatchAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setMatchAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setMatchAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setMatchAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("org_code")) {
      Object obj = map.get("org_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("biz_order_no")) {
      Object obj = map.get("biz_order_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("charge_up_amount")) {
      Object obj = map.get("charge_up_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setChargeUpAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setChargeUpAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setChargeUpAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setChargeUpAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setChargeUpAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("payment_amount")) {
      Object obj = map.get("payment_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPaymentAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPaymentAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPaymentAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPaymentAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPaymentAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("recog_user_name")) {
      Object obj = map.get("recog_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecogUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_category")) {
      Object obj = map.get("invoice_category");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceCategory((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("area_type")) {
      Object obj = map.get("area_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAreaType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("recog_batch_no")) {
      Object obj = map.get("recog_batch_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecogBatchNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_cancel_check")) {
      Object obj = map.get("is_cancel_check");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsCancelCheck((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sale_confirm_no")) {
      Object obj = map.get("sale_confirm_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSaleConfirmNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sale_confirm_status")) {
      Object obj = map.get("sale_confirm_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSaleConfirmStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sale_confirm_period")) {
      Object obj = map.get("sale_confirm_period");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSaleConfirmPeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSaleConfirmPeriod((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSaleConfirmPeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSaleConfirmPeriod(null);
      }
    }
    if(map.containsKey("charge_up_person")) {
      Object obj = map.get("charge_up_person");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeUpPerson((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payment_batch_no")) {
      Object obj = map.get("payment_batch_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentBatchNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payment_user_name")) {
      Object obj = map.get("payment_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reimbursement_status")) {
      Object obj = map.get("reimbursement_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReimbursementStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("turn_out_remark")) {
      Object obj = map.get("turn_out_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTurnOutRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("red_time")) {
      Object obj = map.get("red_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRedTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setRedTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRedTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setRedTime(null);
      }
    }
    if(map.containsKey("red_notification_no")) {
      Object obj = map.get("red_notification_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRedNotificationNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("red_status")) {
      Object obj = map.get("red_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRedStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("report_no")) {
      Object obj = map.get("report_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReportNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("report_time")) {
      Object obj = map.get("report_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setReportTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setReportTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReportTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setReportTime(null);
      }
    }
    if(map.containsKey("report_status")) {
      Object obj = map.get("report_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReportStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_external_code")) {
      Object obj = map.get("purchaser_external_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserExternalCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_external_code")) {
      Object obj = map.get("seller_external_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerExternalCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_name")) {
      Object obj = map.get("org_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("system_source")) {
      Object obj = map.get("system_source");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSystemSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("recog_order_no")) {
      Object obj = map.get("recog_order_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecogOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("retreat_time")) {
      Object obj = map.get("retreat_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRetreatTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setRetreatTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRetreatTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setRetreatTime(null);
      }
    }
    if(map.containsKey("entry_status")) {
      Object obj = map.get("entry_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEntryStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("entry_time")) {
      Object obj = map.get("entry_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setEntryTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setEntryTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setEntryTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setEntryTime(null);
      }
    }
    if(map.containsKey("entry_user_name")) {
      Object obj = map.get("entry_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEntryUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("entry_remark")) {
      Object obj = map.get("entry_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEntryRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("entry_tab_status")) {
      Object obj = map.get("entry_tab_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEntryTabStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("no_compliance_type")) {
      Object obj = map.get("no_compliance_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNoComplianceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("recog_user_id")) {
      Object obj = map.get("recog_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRecogUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRecogUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setRecogUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("follow_up_status")) {
      Object obj = map.get("follow_up_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFollowUpStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("risk_handle_status")) {
      Object obj = map.get("risk_handle_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRiskHandleStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("follow_up_remark")) {
      Object obj = map.get("follow_up_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFollowUpRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("hang_time")) {
      Object obj = map.get("hang_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setHangTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setHangTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setHangTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setHangTime(null);
      }
    }
    if(map.containsKey("hang_user")) {
      Object obj = map.get("hang_user");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHangUser((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("exception_time")) {
      Object obj = map.get("exception_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setExceptionTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setExceptionTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExceptionTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setExceptionTime(null);
      }
    }
    if(map.containsKey("exception_create_user")) {
      Object obj = map.get("exception_create_user");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExceptionCreateUser((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reopen_invoice_no")) {
      Object obj = map.get("reopen_invoice_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReopenInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reopen_invoice_code")) {
      Object obj = map.get("reopen_invoice_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReopenInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("business_control_status")) {
      Object obj = map.get("business_control_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessControlStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("function_group")) {
      Object obj = map.get("function_group");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFunctionGroup((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("function_group_way")) {
      Object obj = map.get("function_group_way");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFunctionGroupWay((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("waybill_no")) {
      Object obj = map.get("waybill_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWaybillNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext27")) {
      Object obj = map.get("ext27");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt27((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext28")) {
      Object obj = map.get("ext28");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt28((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext29")) {
      Object obj = map.get("ext29");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt29((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext30")) {
      Object obj = map.get("ext30");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt30((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext31")) {
      Object obj = map.get("ext31");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt31((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext32")) {
      Object obj = map.get("ext32");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt32((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext33")) {
      Object obj = map.get("ext33");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt33((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext34")) {
      Object obj = map.get("ext34");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt34((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext35")) {
      Object obj = map.get("ext35");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt35((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext36")) {
      Object obj = map.get("ext36");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt36((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext37")) {
      Object obj = map.get("ext37");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt37((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext26")) {
      Object obj = map.get("ext26");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt26((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reverse_list")) {
      Object obj = map.get("reverse_list");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReverseList((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("recog_sheet")) {
      Object obj = map.get("recog_sheet");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecogSheet((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("biz_tag1")) {
      Object obj = map.get("biz_tag1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizTag1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("biz_tag2")) {
      Object obj = map.get("biz_tag2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizTag2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("biz_tag3")) {
      Object obj = map.get("biz_tag3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizTag3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("follow_up_user")) {
      Object obj = map.get("follow_up_user");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFollowUpUser((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("follow_up_time")) {
      Object obj = map.get("follow_up_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setFollowUpTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setFollowUpTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setFollowUpTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setFollowUpTime(null);
      }
    }
    if(map.containsKey("jv_pc")) {
      Object obj = map.get("jv_pc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJvPc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("jv_code")) {
      Object obj = map.get("jv_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJvCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("store_code")) {
      Object obj = map.get("store_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rms_code")) {
      Object obj = map.get("rms_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRmsCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("list_import_user")) {
      Object obj = map.get("list_import_user");
      if(obj != null) {
        if(obj instanceof String) {
          this.setListImportUser((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("list_import_time")) {
      Object obj = map.get("list_import_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setListImportTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setListImportTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setListImportTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setListImportTime(null);
      }
    }
    if(map.containsKey("market")) {
      Object obj = map.get("market");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMarket((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("area")) {
      Object obj = map.get("area");
      if(obj != null) {
        if(obj instanceof String) {
          this.setArea((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("un_certified_reason")) {
      Object obj = map.get("un_certified_reason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnCertifiedReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("un_certified_remark")) {
      Object obj = map.get("un_certified_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnCertifiedRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("risk_invoice_category")) {
      Object obj = map.get("risk_invoice_category");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRiskInvoiceCategory((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("origin_biz_order_no")) {
      Object obj = map.get("origin_biz_order_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginBizOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("send_exception_remark")) {
      Object obj = map.get("send_exception_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSendExceptionRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_repeat")) {
      Object obj = map.get("is_repeat");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsRepeat((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_need_auth")) {
      Object obj = map.get("is_need_auth");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsNeedAuth((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_send_exception")) {
      Object obj = map.get("is_send_exception");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsSendException((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("return_type")) {
      Object obj = map.get("return_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReturnType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("need_express")) {
      Object obj = map.get("need_express");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNeedExpress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_sync_time")) {
      Object obj = map.get("seller_sync_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSellerSyncTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSellerSyncTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSellerSyncTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSellerSyncTime(null);
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("all_electric_invoice_no")) {
      Object obj = map.get("all_electric_invoice_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAllElectricInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("back_express_number")) {
      Object obj = map.get("back_express_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBackExpressNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("return_batch")) {
      Object obj = map.get("return_batch");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReturnBatch((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("biz_order_id")) {
      Object obj = map.get("biz_order_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBizOrderId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBizOrderId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setBizOrderId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("outer_invoice_id")) {
      Object obj = map.get("outer_invoice_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOuterInvoiceId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_tenant_id")) {
      Object obj = map.get("seller_tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSellerTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSellerTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSellerTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("customer_no")) {
      Object obj = map.get("customer_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("recog_way")) {
      Object obj = map.get("recog_way");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecogWay((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("businessAndInvoiceMainRelation.id")) {
        Object obj = map.get("businessAndInvoiceMainRelation.id");
        if(obj instanceof Long) {
          this.setBusinessAndInvoiceMainRelationId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBusinessAndInvoiceMainRelationId(Long.parseLong((String)obj));
        }
      }
  }
}
