package com.xforceplus.purchaserinvoicemanagesaas.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 验真相关信息
 * </p>
 *
 * @author ultraman
 * @since 2024-05-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceVerify implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 验真人姓名
   */
  private String verifyUserName;

  /**
   * 验真人id
   */
  private Long verifyUserId;

  /**
   * 验真时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime verifyTime;

  /**
   * 验真次数
   */
  private Long verifyNumber;

  /**
   * 验真备注
   */
  private String verifyRemark;

  /**
   * 验真状态
   */
  private String verifyStatus;

  /**
   * 验签状态
   */
  private String verifySignStatus;

  /**
   * 数据状态
   */
  private String dataStatus;

  /**
   * 税件验真任务id
   */
  private String taxTaskId;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 组织id
   */
  private Long orgId;

  /**
   * 发票号码
   */
  private String invoiceNo;

  /**
   * 发票代码
   */
  private String invoiceCode;

  /**
   * 全电发票号码
   */
  private String allElectricInvoiceNo;


  /**
   * 对一关联关系 关联对象 invoiceMain
   */
    private Long verifyAndInvoiceMainRelationId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("verify_user_name", verifyUserName);
      map.put("verify_user_id", verifyUserId);
      map.put("verify_time", BocpGenUtils.toTimestamp(verifyTime));
      map.put("verify_number", verifyNumber);
      map.put("verify_remark", verifyRemark);
      map.put("verify_status", verifyStatus);
      map.put("verify_sign_status", verifySignStatus);
      map.put("data_status", dataStatus);
      map.put("tax_task_id", taxTaskId);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("org_id", orgId);
      map.put("invoice_no", invoiceNo);
      map.put("invoice_code", invoiceCode);
      map.put("all_electric_invoice_no", allElectricInvoiceNo);

       map.put("verifyAndInvoiceMainRelation.id", verifyAndInvoiceMainRelationId);
      return map;
  }

  public static InvoiceVerify fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceVerify entity = new InvoiceVerify();
    if(map.containsKey("verify_user_name")) {
      Object obj = map.get("verify_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVerifyUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verify_user_id")) {
      Object obj = map.get("verify_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVerifyUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setVerifyUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setVerifyUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("verify_time")) {
      Object obj = map.get("verify_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVerifyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setVerifyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setVerifyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setVerifyTime(null);
      }
    }
    if(map.containsKey("verify_number")) {
      Object obj = map.get("verify_number");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVerifyNumber((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setVerifyNumber(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setVerifyNumber(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("verify_remark")) {
      Object obj = map.get("verify_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVerifyRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verify_status")) {
      Object obj = map.get("verify_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVerifyStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verify_sign_status")) {
      Object obj = map.get("verify_sign_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVerifySignStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("data_status")) {
      Object obj = map.get("data_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_task_id")) {
      Object obj = map.get("tax_task_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxTaskId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("all_electric_invoice_no")) {
      Object obj = map.get("all_electric_invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAllElectricInvoiceNo((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("verifyAndInvoiceMainRelation.id")) {
        Object obj = map.get("verifyAndInvoiceMainRelation.id");
      if(obj instanceof Long) {
        entity.setVerifyAndInvoiceMainRelationId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setVerifyAndInvoiceMainRelationId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("verify_user_name")) {
      Object obj = map.get("verify_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVerifyUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("verify_user_id")) {
      Object obj = map.get("verify_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setVerifyUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setVerifyUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setVerifyUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("verify_time")) {
      Object obj = map.get("verify_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setVerifyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setVerifyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setVerifyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setVerifyTime(null);
      }
    }
    if(map.containsKey("verify_number")) {
      Object obj = map.get("verify_number");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setVerifyNumber((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setVerifyNumber(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setVerifyNumber(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("verify_remark")) {
      Object obj = map.get("verify_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVerifyRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("verify_status")) {
      Object obj = map.get("verify_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVerifyStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("verify_sign_status")) {
      Object obj = map.get("verify_sign_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVerifySignStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("data_status")) {
      Object obj = map.get("data_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDataStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_task_id")) {
      Object obj = map.get("tax_task_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxTaskId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrgId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrgId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("all_electric_invoice_no")) {
      Object obj = map.get("all_electric_invoice_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAllElectricInvoiceNo((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("verifyAndInvoiceMainRelation.id")) {
        Object obj = map.get("verifyAndInvoiceMainRelation.id");
        if(obj instanceof Long) {
          this.setVerifyAndInvoiceMainRelationId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setVerifyAndInvoiceMainRelationId(Long.parseLong((String)obj));
        }
      }
  }
}
