package com.xforceplus.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * biz_makeout_status
 * </p>
 *
 * @author ultraman
 * @since 2025-09-23
 */
public enum BizMakeoutStatus {

    _0("0", "未开票"),
    _1("1", "开票中"),
    _2("2", "已开票"),
    _3("3", "已生成预制发票"),
    _4("4", "部分未提交+部分已生成预制发票"),
    _5("5", "部分未提交+部分已开票"),
    _6("6", "部分已生成预制发票+部分已开票"),
    _7("7", "部分未提交+部分已生成预制发票+部分已开票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BizMakeoutStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BizMakeoutStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            default:
                return null;
        }
    }
}
