package com.xforceplus.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * cross_city_sign
 * </p>
 *
 * @author ultraman
 * @since 2025-09-23
 */
public enum CrossCitySign {

    Y("Y", "是"),
    N("N", "否");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    CrossCitySign(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CrossCitySign fromCode(String code){
        switch(code) {
            case "Y":
                return Y;
            case "N":
                return N;
            default:
                return null;
        }
    }
}
