package com.xforceplus.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * customs_payment_drawback_checked_tab_flag
 * </p>
 *
 * @author ultraman
 * @since 2025-09-23
 */
public enum CustomsPaymentDrawbackCheckedTabFlag {

    已勾选("已勾选", "已勾选"),
    已认证("已认证", "已认证");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    CustomsPaymentDrawbackCheckedTabFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CustomsPaymentDrawbackCheckedTabFlag fromCode(String code){
        switch(code) {
            case "已勾选":
                return 已勾选;
            case "已认证":
                return 已认证;
            default:
                return null;
        }
    }
}
