package com.xforceplus.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * follow_up_status
 * </p>
 *
 * @author ultraman
 * @since 2025-09-23
 */
public enum FollowUpStatus {

    _01("01", "换票与供应商协商中"),
    _02("02", "换票-供应商同意换票 (我司未收回)"),
    _03("03", "换票-我司已收票未交到税务组"),
    _04("04", "已换票"),
    _05("05", "放弃确认税金抵扣损失"),
    _06("06", "其他"),
    _00("00", "无");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    FollowUpStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FollowUpStatus fromCode(String code){
        switch(code) {
            case "01":
                return _01;
            case "02":
                return _02;
            case "03":
                return _03;
            case "04":
                return _04;
            case "05":
                return _05;
            case "06":
                return _06;
            case "00":
                return _00;
            default:
                return null;
        }
    }
}
