package com.xforceplus.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_check_tab_flag
 * </p>
 *
 * @author ultraman
 * @since 2025-09-23
 */
public enum InvoiceCheckTabFlag {

    可勾选("可勾选", "可勾选"),
    配置拦截("配置拦截", "配置拦截"),
    不可勾选("不可勾选", "不可勾选");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceCheckTabFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceCheckTabFlag fromCode(String code){
        switch(code) {
            case "可勾选":
                return 可勾选;
            case "配置拦截":
                return 配置拦截;
            case "不可勾选":
                return 不可勾选;
            default:
                return null;
        }
    }
}
