package com.xforceplus.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_drawback_checked_tab_flag
 * </p>
 *
 * @author ultraman
 * @since 2025-09-23
 */
public enum InvoiceDrawbackCheckedTabFlag {

    已勾选("已勾选", "已勾选"),
    已认证("已认证", "已认证"),
    已转出("已转出", "已转出");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceDrawbackCheckedTabFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceDrawbackCheckedTabFlag fromCode(String code){
        switch(code) {
            case "已勾选":
                return 已勾选;
            case "已认证":
                return 已认证;
            case "已转出":
                return 已转出;
            default:
                return null;
        }
    }
}
