package com.xforceplus.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * area_type
 * </p>
 *
 * @author ultraman
 * @since 2025-10-23
 */
public enum AreaType {

    HUABEI("huabei", "华北"),
    HUADONG("huadong", "华东"),
    DONGBEI("dongbei", "东北"),
    HUANAN("huanan", "华南"),
    HUAZHONG("huazhong", "华中");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AreaType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AreaType fromCode(String code){
        switch(code) {
            case "huabei":
                return HUABEI;
            case "huadong":
                return HUADONG;
            case "dongbei":
                return DONGBEI;
            case "huanan":
                return HUANAN;
            case "huazhong":
                return HUAZHONG;
            default:
                return null;
        }
    }
}
