package com.xforceplus.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * auth_style
 * </p>
 *
 * @author ultraman
 * @since 2025-10-23
 */
public enum AuthStyle {

    _0("0", "无"),
    _10("10", "页面手工勾选"),
    _11("11", "外部接口勾选"),
    _12("12", "国税底账勾选"),
    _13("13", "系统自动勾选"),
    _14("14", "文件导入勾选"),
    _21("21", "平台取消勾选"),
    _22("22", "国税取消勾选"),
    _15("15", "手工修改勾选"),
    _31("31", "票易通传统认证"),
    _32("32", "非票易通体外导入传统认证"),
    _33("33", "非票易通传统认证"),
    _34("34", "非票易通退税确认");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AuthStyle(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AuthStyle fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            case "13":
                return _13;
            case "14":
                return _14;
            case "21":
                return _21;
            case "22":
                return _22;
            case "15":
                return _15;
            case "31":
                return _31;
            case "32":
                return _32;
            case "33":
                return _33;
            case "34":
                return _34;
            default:
                return null;
        }
    }
}
