package com.xforceplus.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * function_code
 * </p>
 *
 * @author ultraman
 * @since 2025-10-23
 */
public enum FunctionCode {

    _1("1", "一税号多租户组织"),
    _2("2", "底账同步自动触发验真"),
    _3("3", "验真失败补偿"),
    _4("4", "备注解析单号"),
    _5("5", "下发字段映射"),
    _6("6", "电子影像租户定制字段"),
    _7("7", "发票源文件推送电子影像"),
    _8("8", "底账同步自动触发取消配单"),
    _9("9", "发票不合规校验"),
    _10("10", "接收发票数据字段转换"),
    _11("11", "协同开票数据过滤配置"),
    _12("12", "迁移4.0数据字段映射"),
    _13("13", "openapi发票查询接口支持查询参数配置"),
    _14("14", "税件归集来源数据验真状态配置"),
    _15("15", "openapi业务单更新接口支持参数配置"),
    _16("16", "openapi业务单更新参数是否继承到发票"),
    _17("17", "影像地址转换"),
    _18("18", "基于税号过滤发票数据"),
    _19("19", "租户税号公司编号映射配置"),
    _20("20", "税件归集来源数据识别状态配置"),
    _21("21", "发票取消入账"),
    _22("22", "归集发票源文件同步至电子影像配置"),
    _23("23", "底账未获取税号邮箱配置"),
    _24("24", "字段优先级配置"),
    _25("25", "是否删除发票明细"),
    _26("26", "配单下发配置"),
    _27("27", "是否开启触发经营非经营性判断"),
    _28("28", "老风险发票开启配置"),
    _29("29", "业务配置字段条件组集合"),
    _30("30", "单据上传是否开启自动找票"),
    _31("31", "单据上传是否开启拆词"),
    _32("32", "发票上传是否开启拆词");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    FunctionCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FunctionCode fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            case "13":
                return _13;
            case "14":
                return _14;
            case "15":
                return _15;
            case "16":
                return _16;
            case "17":
                return _17;
            case "18":
                return _18;
            case "19":
                return _19;
            case "20":
                return _20;
            case "21":
                return _21;
            case "22":
                return _22;
            case "23":
                return _23;
            case "24":
                return _24;
            case "25":
                return _25;
            case "26":
                return _26;
            case "27":
                return _27;
            case "28":
                return _28;
            case "29":
                return _29;
            case "30":
                return _30;
            case "31":
                return _31;
            case "32":
                return _32;
            default:
                return null;
        }
    }
}
