package com.xforceplus.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * function_group
 * </p>
 *
 * @author ultraman
 * @since 2025-10-23
 */
public enum FunctionGroup {

    AP("AP", "AP"),
    INV("INV", "INV"),
    WAREHOUSE("Warehouse", "Warehouse"),
    GL1("GL1", "GL1"),
    GL2("GL2", "GL2"),
    GL3("GL3", "GL3"),
    FA("FA", "FA"),
    TAX("TAX", "TAX"),
    AP_CI("AP_CI", "AP(CI)"),
    INV_STORE("INV_STORE", "INV(STORE)"),
    SALES__J_P("Sales_JP", "Sales(JP)"),
    SALES__E_C_O_M("Sales_ECOM", "Sales(ECOM)"),
    SALES__R_E_C_O_N("Sales_RECON", "Sales(RECON)"),
    ER("ER", "ER"),
    __("--", "NULL");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    FunctionGroup(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FunctionGroup fromCode(String code){
        switch(code) {
            case "AP":
                return AP;
            case "INV":
                return INV;
            case "Warehouse":
                return WAREHOUSE;
            case "GL1":
                return GL1;
            case "GL2":
                return GL2;
            case "GL3":
                return GL3;
            case "FA":
                return FA;
            case "TAX":
                return TAX;
            case "AP_CI":
                return AP_CI;
            case "INV_STORE":
                return INV_STORE;
            case "Sales_JP":
                return SALES__J_P;
            case "Sales_ECOM":
                return SALES__E_C_O_M;
            case "Sales_RECON":
                return SALES__R_E_C_O_N;
            case "ER":
                return ER;
            case "--":
                return __;
            default:
                return null;
        }
    }
}
