package com.xforceplus.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ncp_handle_type
 * </p>
 *
 * @author ultraman
 * @since 2025-10-23
 */
public enum NcpHandleType {

    _0("0", "无"),
    _1("1", "属于自产农产品销售发票"),
    _2("2", "不属于自产农产品销售发票"),
    _3("3", "按票面税额抵扣"),
    _4("4", "按票面金额和基础扣除率计算抵扣"),
    _5("5", "部分属于自产农产品销售发票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    NcpHandleType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static NcpHandleType fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            default:
                return null;
        }
    }
}
