package com.xforceplus.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * auth_use
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum AuthUse {

    _1("1", "抵扣勾选"),
    _2("2", "不抵扣勾选"),
    _3("3", "退税勾选"),
    _10("10", "撤销抵扣勾选"),
    _20("20", "撤销不抵扣勾选"),
    _30("30", "撤销退税勾选"),
    _0("0", "无");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AuthUse(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AuthUse fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "10":
                return _10;
            case "20":
                return _20;
            case "30":
                return _30;
            case "0":
                return _0;
            default:
                return null;
        }
    }
}
