package com.xforceplus.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * error_code
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum ErrorCode {

    INVALIDATE_INVOICE_CODE("invalidate_invoice_code", "无效的发票代码");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ErrorCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ErrorCode fromCode(String code){
        switch(code) {
            case "invalidate_invoice_code":
                return INVALIDATE_INVOICE_CODE;
            default:
                return null;
        }
    }
}
