package com.xforceplus.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ext9_wilmar
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum Ext9Wilmar {

    CC("CC", "CC-进项税，11%，货物（应税不可分-3900007）"),
    P2("P2", "P2-进项税，6%（3900005"),
    P5("P5", "P5-进项税，17%（3900005）"),
    F1("F1", "F1-进项税，13%（3900005）"),
    F2("F2", "F2-进项税，13%（应税不可分-3900007）"),
    E1("E1", "E1-进项税，9%，货物（增税票可分-3900005）"),
    F3("F3", "F3-进项税，13%（免税项目-3900008）"),
    E2("E2", "E2-进项税，9%，货物（应税不可分-3900007）"),
    D1("D1", "D1-进项税，16%（3900005）"),
    D2("D2", "D2-进项税，16%（应税不可分-3900007）"),
    D3("D3", "D3-进项税，16%（免税项目-3900008）"),
    A1("A1", "A1-进项税，10%，货物（增税票可分-3900005）"),
    E6("E6", "E6-进项税，9%，适用核定扣除（农产品采购税金-应税项目-3000106）"),
    A2("A2", "A2-进项税，10%，货物（应税不可分-3900007）"),
    E7("E7", "E7-进项税，9%，适作核定扣除（农产品采购税金-不可分-3000107）"),
    PC("PC", "PC-进项税，17%（应税不可分-3900007）"),
    ZN("ZN", "ZN-进项税，1%，小规模纳税人进项税（应税可分-3900005）"),
    A6("A6", "A6-进项税，10%，适用核定扣除（农产品采购税金-应税项目-3000106）"),
    ZP("ZP", "ZP-进项税，1%，小规模纳税人进项税（应税不可分-3900007）"),
    A7("A7", "A7-进项税，10%，适作核定扣除（农产品采购税金-不可分-3000107）"),
    ZQ("ZQ", "ZQ-进项税，1%，小规模纳税人进项税（免税及非应税-3900008）"),
    CB("CB", "CB-进项税，11%，货物（增税票可分-3900005）");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    Ext9Wilmar(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Ext9Wilmar fromCode(String code){
        switch(code) {
            case "CC":
                return CC;
            case "P2":
                return P2;
            case "P5":
                return P5;
            case "F1":
                return F1;
            case "F2":
                return F2;
            case "E1":
                return E1;
            case "F3":
                return F3;
            case "E2":
                return E2;
            case "D1":
                return D1;
            case "D2":
                return D2;
            case "D3":
                return D3;
            case "A1":
                return A1;
            case "E6":
                return E6;
            case "A2":
                return A2;
            case "E7":
                return E7;
            case "PC":
                return PC;
            case "ZN":
                return ZN;
            case "A6":
                return A6;
            case "ZP":
                return ZP;
            case "A7":
                return A7;
            case "ZQ":
                return ZQ;
            case "CB":
                return CB;
            default:
                return null;
        }
    }
}
