package com.xforceplus.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * is_legal_synergetics
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum IsLegalSynergetics {

    是("是", "是"),
    否("否", "否");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    IsLegalSynergetics(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IsLegalSynergetics fromCode(String code){
        switch(code) {
            case "是":
                return 是;
            case "否":
                return 否;
            default:
                return null;
        }
    }
}
