package com.xforceplus.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ncp_operate_type
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum NcpOperateType {

    _0("0", "无"),
    _1("1", "农产品处理类型"),
    _2("2", "代开农产品发票录入"),
    _3("3", "农产品发票加计扣除"),
    _4("4", "农产品缴款书加计扣除");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    NcpOperateType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static NcpOperateType fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            default:
                return null;
        }
    }
}
