package com.xforceplus.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * no_compliance_type
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum NoComplianceType {

    _0("0", "无"),
    _1("1", "购方抬头不一致"),
    _2("2", "购方地址电话不一致"),
    _3("3", "购方银行账号不一致"),
    _4("4", "销方失信"),
    _5("5", "敏感词(销方名称)"),
    _6("6", "发票状态异常"),
    _7("7", "购方公司未维护"),
    _8("8", "其他"),
    _9("9", "含有自定义预警项"),
    _10("10", "敏感词(商品名称)"),
    _11("11", "自定义预警"),
    _12("12", "勾选异常"),
    _13("13", "抵扣异常"),
    _14("14", "发票转异常"),
    _15("15", "发票退票"),
    _16("16", "验真人无权限");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    NoComplianceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static NoComplianceType fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            case "13":
                return _13;
            case "14":
                return _14;
            case "15":
                return _15;
            case "16":
                return _16;
            default:
                return null;
        }
    }
}
