package com.xforceplus.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * recog_delete_remark
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum RecogDeleteRemark {

    _0("0", "--"),
    _1("1", "发票类型开错"),
    _2("2", "附件里含有敏感信息"),
    _3("3", "实票与预票不一致-品名有误"),
    _4("4", "实票与预票不一致-税收编码有误"),
    _5("5", "实票与预票不一致-备注栏-地址备注有误"),
    _6("6", "实票与预票不一致-备注栏-项目名称有误"),
    _7("7", "实票与预票不一致-金额有误"),
    _8("8", "实票与预票不一致-税率有误"),
    _9("9", "实票与预票不一致-发票抬头开错"),
    _10("10", "实票与预票不一致-购方税号开错"),
    _11("11", "单价、数量未拆分"),
    _12("12", "购方开票信息不全"),
    _13("13", "产值被驳回"),
    _14("14", "产值单缺少附件"),
    _15("15", "产值需走线下"),
    _16("16", "单价小于“1”，不符合实际"),
    _17("17", "发票状态异常"),
    _18("18", "其他");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    RecogDeleteRemark(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RecogDeleteRemark fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            case "13":
                return _13;
            case "14":
                return _14;
            case "15":
                return _15;
            case "16":
                return _16;
            case "17":
                return _17;
            case "18":
                return _18;
            default:
                return null;
        }
    }
}
