package com.xforceplus.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * recog_delete_way
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum RecogDeleteWay {

    _0("0", "自动删除"),
    _1("1", "手动删除");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    RecogDeleteWay(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RecogDeleteWay fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            default:
                return null;
        }
    }
}
