package com.xforceplus.purchaserinvoicemanagesaas.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 发票池展示对象
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceView implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 发票号码
   */
  private String invoiceNo;

  /**
   * 发票代码
   */
  private String invoiceCode;

  /**
   * 发票类型
   */
  private String invoiceType;

  /**
   * 勾选人id
   */
  private String checkUserId;

  /**
   * 勾选人姓名
   */
  private String checkUserName;

  /**
   * 勾选时间
   */
  private String checkTime;

  /**
   * 认证方式
   */
  private String authStyle;

  /**
   * 抵扣用途
   */
  private String authUse;

  /**
   * 认证备注
   */
  private String authRemark;

  /**
   * 认证状态
   */
  private String authStatus;

  /**
   * 可抵扣税额
   */
  private String effectiveTaxAmount;

  /**
   * 不抵扣原因
   */
  private String noAuthReason;

  /**
   * 底账确认日期
   */
  private String authBussiDate;

  /**
   * 税款所属期
   */
  private String authTaxPeriod;

  /**
   * 发票状态
   */
  private String invoiceStatus;

  /**
   * 发票来源
   */
  private String invoiceOrig;

  /**
   * 协同标记
   */
  private String cooperateFlag;

  /**
   * 合规状态
   */
  private String complianceStatus;

  /**
   * 退票状态
   */
  private String retreatStatus;

  /**
   * 退票备注
   */
  private String retreatRemark;

  /**
   * 锁定状态
   */
  private String hangStatus;

  /**
   * 锁定原因
   */
  private String hangRemark;

  /**
   * 签收状态
   */
  private String signForStatus;

  /**
   * 签收时间
   */
  private String signForTime;

  /**
   * 记账状态
   */
  private String chargeUpStatus;

  /**
   * 记账日期
   */
  private String chargeUpPeriod;

  /**
   * 记账单号
   */
  private String chargeUpNo;

  /**
   * 付款状态
   */
  private String paymentStatus;

  /**
   * 付款单号
   */
  private String paymentNo;

  /**
   * 付款日期
   */
  private String paymentDate;

  /**
   * 失信状态
   */
  private String blackStatus;

  /**
   * 失信原因
   */
  private String blackRemark;

  /**
   * 进转出状态
   */
  private String turnOutStatus;

  /**
   * 进转出金额
   */
  private String turnOutAmount;

  /**
   * 进转出日期
   */
  private String turnOutPeriod;

  /**
   * 审核状态
   */
  private String auditStatus;

  /**
   * 审核人
   */
  private String auditName;

  /**
   * 审核备注
   */
  private String auditRemark;

  /**
   * 审核时间
   */
  private String auditTime;

  /**
   * 被红冲不含税金额
   */
  private String reserveAmountWithoutTax;

  /**
   * 被红冲税额
   */
  private String reserveTaxAmount;

  /**
   * 被红冲含税金额
   */
  private String reserveAmountWithTax;

  /**
   * 开票日期
   */
  private String paperDrewDate;

  /**
   * 不含税金额
   */
  private String amountWithoutTax;

  /**
   * 税额
   */
  private String taxAmount;

  /**
   * 含税金额
   */
  private String amountWithTax;

  /**
   * 购方名称
   */
  private String purchaserName;

  /**
   * 购方税号
   */
  private String purchaserTaxNo;

  /**
   * 销方名称
   */
  private String sellerName;

  /**
   * 销方税号
   */
  private String sellerTaxNo;

  /**
   * 机器编码
   */
  private String machineCode;

  /**
   * 校验码
   */
  private String checkCode;

  /**
   * 密文
   */
  private String cipherText;

  /**
   * 收款人姓名
   */
  private String cashierName;

  /**
   * 复核人姓名
   */
  private String checkerName;

  /**
   * 开票人姓名
   */
  private String invoicerName;

  /**
   * 购方地址电话
   */
  private String purchaserAddrTel;

  /**
   * 购方开户行及账号
   */
  private String purchaserBankNameAccount;

  /**
   * 销方地址电话
   */
  private String sellerAddrTel;

  /**
   * 销方开户行及账号
   */
  private String sellerBankNameAccount;

  /**
   * 发票备注
   */
  private String invoiceRemark;

  /**
   * 原发票号码
   */
  private String originInvoiceNo;

  /**
   * 原发票代码
   */
  private String originInvoiceCode;

  /**
   * 代开标记
   */
  private String issueFlag;

  /**
   * 代开名称
   */
  private String issueName;

  /**
   * 代开税号
   */
  private String issueTaxNo;

  /**
   * 特殊发票标记
   */
  private String specialInvoiceFlag;

  /**
   * 租户名称
   */
  private String tenantName;

  /**
   * 是否有销货清单
   */
  private String saleListFlag;

  /**
   * 地区代码
   */
  private String areaCode;

  /**
   * 地区名称
   */
  private String areaName;

  /**
   * 组织id
   */
  private String orgId;

  /**
   * 验真人id
   */
  private String verifyUserId;

  /**
   * 验真人姓名
   */
  private String verifyUserName;

  /**
   * 验真时间
   */
  private String verifyTime;

  /**
   * 验真次数
   */
  private String verifyNumber;

  /**
   * 验真备注
   */
  private String verifyRemark;

  /**
   * 验真状态
   */
  private String verifyStatus;

  /**
   * 验签状态
   */
  private String verifySignStatus;

  /**
   * 税件验真任务id
   */
  private String taxTaskId;

  /**
   * 数据状态
   */
  private String dataStatus;

  /**
   * 红蓝标识
   */
  private String invoiceColor;

  /**
   * 购方公司ID
   */
  private String purchaserCompanyId;

  /**
   * 购方公司编号
   */
  private String purchaserNo;

  /**
   * 发票业务类型
   */
  private String invoiceBusinessType;

  /**
   * 进转出类型
   */
  private String turnOutType;

  /**
   * 底账获取时间
   */
  private String elTime;

  /**
   * 扩展字段1
   */
  private String ext1;

  /**
   * 扩展字段2
   */
  private String ext2;

  /**
   * 扩展字段3
   */
  private String ext3;

  /**
   * 扩展字段4
   */
  private String ext4;

  /**
   * 扩展字段5
   */
  private String ext5;

  /**
   * 扩展字段6
   */
  private String ext6;

  /**
   * 扩展字段7
   */
  private String ext7;

  /**
   * 扩展字段8
   */
  private String ext8;

  /**
   * 扩展字段9
   */
  private String ext9;

  /**
   * 扩展字段10
   */
  private String ext10;

  /**
   * 扩展字段11
   */
  private String ext11;

  /**
   * 扩展字段12
   */
  private String ext12;

  /**
   * 扩展字段13
   */
  private String ext13;

  /**
   * 扩展字段14
   */
  private String ext14;

  /**
   * 扩展字段15
   */
  private String ext15;

  /**
   * 扩展字段16
   */
  private String ext16;

  /**
   * 扩展字段17
   */
  private String ext17;

  /**
   * 扩展字段18
   */
  private String ext18;

  /**
   * 扩展字段19
   */
  private String ext19;

  /**
   * 扩展字段20
   */
  private String ext20;

  /**
   * 扩展字段21
   */
  private String ext21;

  /**
   * 扩展字段22
   */
  private String ext22;

  /**
   * 扩展字段23
   */
  private String ext23;

  /**
   * 扩展字段24
   */
  private String ext24;

  /**
   * 扩展字段25
   */
  private String ext25;

  /**
   * 识别时间
   */
  private String recogTime;

  /**
   * 识别状态
   */
  private String recogStatus;

  /**
   * 匹配状态
   */
  private String matchStatus;

  /**
   * 匹配时间
   */
  private String matchTime;

  /**
   * 匹配金额
   */
  private String matchAmount;

  /**
   * 组织code
   */
  private String orgCode;

  /**
   * 税率
   */
  private String taxRate;

  /**
   * 全电发票号码
   */
  private String allElectricInvoiceNo;

  /**
   * 底账是否已到
   */
  private String elSyncFlag;

  /**
   * 业务单号
   */
  private String bizOrderNo;

  /**
   * 是否可勾选
   */
  private String isCheck;

  /**
   * 是否配置拦截
   */
  private String isIntercept;

  /**
   * 是否不可勾选
   */
  private String isNotCheck;

  /**
   * 是否离线勾选
   */
  private String isOfflineCheck;

  /**
   * 是否自动勾选
   */
  private String isAutoCheck;

  /**
   * 记账金额
   */
  private String chargeUpAmount;

  /**
   * 付款金额
   */
  private String paymentAmount;

  /**
   * 扫描人姓名
   */
  private String recogUserName;

  /**
   * 所属种类
   */
  private String invoiceCategory;

  /**
   * 区域
   */
  private String areaType;

  /**
   * 扫描批次号
   */
  private String recogBatchNo;

  /**
   * 是否需取消勾选
   */
  private String isCancelCheck;

  /**
   * 购方地址
   */
  private String purchaserAddress;

  /**
   * 购方电话
   */
  private String purchaserTel;

  /**
   * 购方银行名称
   */
  private String purchaserBankName;

  /**
   * 购方银行账号
   */
  private String purchaserBankAccount;

  /**
   * 销方地址
   */
  private String sellerAddress;

  /**
   * 销方电话
   */
  private String sellerTel;

  /**
   * 销方银行名称
   */
  private String sellerBankName;

  /**
   * 销方银行账号
   */
  private String sellerBankAccount;

  /**
   * 核销单号
   */
  private String saleConfirmNo;

  /**
   * 核销状态
   */
  private String saleConfirmStatus;

  /**
   * 核销日期
   */
  private String saleConfirmPeriod;

  /**
   * 记账人
   */
  private String chargeUpPerson;

  /**
   * 付款批次号
   */
  private String paymentBatchNo;

  /**
   * 付款操作人姓名
   */
  private String paymentUserName;

  /**
   * 报账状态
   */
  private String reportStatus;

  /**
   * 报账单号
   */
  private String reportNo;

  /**
   * 报账时间
   */
  private String reportTime;

  /**
   * 报销状态
   */
  private String reimbursementStatus;

  /**
   * 进转出备注
   */
  private String turnOutRemark;

  /**
   * 红冲时间
   */
  private String redTime;

  /**
   * 红字信息表编号
   */
  private String redNotificationNo;

  /**
   * 红冲状态
   */
  private String redStatus;

  /**
   * 购方外部编号
   */
  private String purchaserExternalCode;

  /**
   * 销方外部编号
   */
  private String sellerExternalCode;

  /**
   * 组织名称
   */
  private String orgName;

  /**
   * 系统来源
   */
  private String systemSource;

  /**
   * 扫描单号
   */
  private String recogOrderNo;

  /**
   * 退票时间
   */
  private String retreatTime;

  /**
   * 农产品类型
   */
  private String ncpType;

  /**
   * 农产品处理类型
   */
  private String ncpHandleType;

  /**
   * 农产品处理状态
   */
  private String ncpHandleStatus;

  /**
   * 农产品处理时间
   */
  private String ncpHandleTime;

  /**
   * 农产品处理人姓名
   */
  private String ncpHandleUserName;

  /**
   * 农产品处理备注
   */
  private String ncpHandleRemark;

  /**
   * 农产品部分金额
   */
  private String ncpPartAmount;

  /**
   * 入账状态
   */
  private String entryStatus;

  /**
   * 入账时间
   */
  private String entryTime;

  /**
   * 入账操作人名称
   */
  private String entryUserName;

  /**
   * 入账备注
   */
  private String entryRemark;

  /**
   * 入账Tab栏状态
   */
  private String entryTabStatus;

  /**
   * 发票风险等级
   */
  private String ncpManageStatus;

  /**
   * 不合规类型
   */
  private String noComplianceType;

  /**
   * 扫描人id
   */
  private String recogUserId;

  /**
   * 跟进状态
   */
  private String followUpStatus;

  /**
   * 风险处理状态
   */
  private String riskHandleStatus;

  /**
   * 跟进说明
   */
  private String followUpRemark;

  /**
   * 锁定时间
   */
  private String hangTime;

  /**
   * 锁定人
   */
  private String hangUser;

  /**
   * 异常日期
   */
  private String exceptionTime;

  /**
   * 异常创建人
   */
  private String exceptionCreateUser;

  /**
   * 重开发票号码
   */
  private String reopenInvoiceNo;

  /**
   * 重开发票代码
   */
  private String reopenInvoiceCode;

  /**
   * 业务管控状态
   */
  private String businessControlStatus;

  /**
   * 功能组别
   */
  private String functionGroup;

  /**
   * 组别更新方式
   */
  private String functionGroupWay;

  /**
   * 物流单号
   */
  private String waybillNo;

  /**
   * 原全电发票号码
   */
  private String originAllElectricInvoiceNo;

  /**
   * 扩展字段26
   */
  private String ext26;

  /**
   * 扩展字段27
   */
  private String ext27;

  /**
   * 扩展字段28
   */
  private String ext28;

  /**
   * 扩展字段29
   */
  private String ext29;

  /**
   * 扩展字段30
   */
  private String ext30;

  /**
   * 扩展字段31
   */
  private String ext31;

  /**
   * 扩展字段32
   */
  private String ext32;

  /**
   * 扩展字段33
   */
  private String ext33;

  /**
   * 扩展字段34
   */
  private String ext34;

  /**
   * 扩展字段35
   */
  private String ext35;

  /**
   * 扩展字段36
   */
  private String ext36;

  /**
   * 扩展字段37
   */
  private String ext37;

  /**
   * 红冲列表
   */
  private String reverseList;

  /**
   * 可加计扣除税额
   */
  private String ncpJjkcTaxAmount;

  /**
   * 剩余加计扣除税额
   */
  private String ncpJjkcLeftTaxAmount;

  /**
   * 本次加计扣除税额
   */
  private String ncpJjkcCurrentTaxAmount;

  /**
   * 是否用于加计扣除
   */
  private String ncpJjkcAuthUse;

  /**
   * 加计扣除提交状态
   */
  private String ncpJjkcSubmitStatus;

  /**
   * 加计扣除提交备注
   */
  private String ncpJjkcSubmitRemark;

  /**
   * 加计扣除状态
   */
  private String ncpJjkcStatus;

  /**
   * 扫描联次
   */
  private String recogSheet;

  /**
   * 加计扣除提交时间
   */
  private String ncpJjkcSubmitTime;

  /**
   * 累计加计扣除税额
   */
  private String ncpJjkcAccumTaxAmount;

  /**
   * 是否取消过勾选
   */
  private String isCancelledCheck;

  /**
   * 拓展字段1
   */
  private String bizTag1;

  /**
   * 拓展字段2
   */
  private String bizTag2;

  /**
   * 拓展字段3
   */
  private String bizTag3;

  /**
   * 勾选请求时间
   */
  private String authRequestTime;

  /**
   * 跟进人
   */
  private String followUpUser;

  /**
   * 跟进时间
   */
  private String followUpTime;

  /**
   * JV/PC
   */
  private String jvPc;

  /**
   * JV/CODE
   */
  private String jvCode;

  /**
   * 门店编码
   */
  private String storeCode;

  /**
   * RMS代码
   */
  private String rmsCode;

  /**
   * 清单导入人
   */
  private String listImportUser;

  /**
   * 清单导入时间
   */
  private String listImportTime;

  /**
   * 市场
   */
  private String market;

  /**
   * 区域
   */
  private String area;

  /**
   * 未认证原因
   */
  private String unCertifiedReason;

  /**
   * 说明
   */
  private String unCertifiedRemark;

  /**
   * 风险发票类别
   */
  private String riskInvoiceCategory;

  /**
   * 原业务单号
   */
  private String originBizOrderNo;

  /**
   * 是否重复发票
   */
  private String isRepeat;

  /**
   * 是否需要认证
   */
  private String isNeedAuth;

  /**
   * 是否转交异常
   */
  private String isSendException;

  /**
   * 转交异常备注
   */
  private String sendExceptionRemark;

  /**
   * 取消勾选时间
   */
  private String authCancelTime;

  /**
   * 组织机构代码
   */
  private String organizationCode;

  /**
   * 车辆类型
   */
  private String vehicleType;

  /**
   * 厂牌型号
   */
  private String vehicleBrand;

  /**
   * 产地
   */
  private String productionArea;

  /**
   * 合格证号
   */
  private String certNo;

  /**
   * 商检单号
   */
  private String inspectionNo;

  /**
   * 发动机号码
   */
  private String engineNo;

  /**
   * 车架号码
   */
  private String vehicleNo;

  /**
   * 吨位
   */
  private String tonnage;

  /**
   * 限乘人数
   */
  private String maxCapacity;

  /**
   * 进口证明书号
   */
  private String importCertNo;

  /**
   * 税务机关名称
   */
  private String taxAuthName;

  /**
   * 税务机关代码
   */
  private String taxAuthCode;

  /**
   * 完税凭证号码
   */
  private String taxPaidProof;

  /**
   * 是否国税取消认证
   */
  private String isTaxCancelAuth;

  /**
   * 国税取消认证时间
   */
  private String taxCancelAuthTime;

  /**
   * 实际认证方式
   */
  private String actualAuthWay;

  /**
   * 销方信息获取时间
   */
  private String sellerSyncTime;

  /**
   * 国税状态最后变更时间
   */
  private String lastModifyTime;

  /**
   * 销方公司编号
   */
  private String sellerNo;

  /**
   * 销方公司id
   */
  private String sellerCompanyId;

  /**
   * 数据分片
   */
  private String dataSharding;

  /**
   * 退回的物流单号
   */
  private String backExpressNumber;

  /**
   * 认证状态
   */
  private String elFlag;

  /**
   * 是否底账未到
   */
  private String isLedgerNotArrive;

  /**
   * 勾选展示原因分类
   */
  private String authShowCategory;

  /**
   * 业务单id
   */
  private String bizOrderId;

  /**
   * 外部发票id
   */
  private String outerInvoiceId;

  /**
   * 销方开具状态
   */
  private String sellerIssuedStatus;

  /**
   * 税率
   */
  private String taxRateDefinition;

  /**
   * 销方租户ID
   */
  private String sellerTenantId;

  /**
   * 自定义编号
   */
  private String customerNo;

  /**
   * 采集方式
   */
  private String recogWay;

  /**
   * 业务标签
   */
  private String businessTag;

  /**
   * 风险状态
   */
  private String riskStatus;

  /**
   * 转出状态
   */
  private String transferStatus;

  /**
   * 组织树
   */
  private String orgTree;

  /**
   * 敏感词
   */
  private String senseWord;

  /**
   * 敏感词控制等级
   */
  private String senseWordLevel;

  /**
   * 购方信息异常原因
   */
  private String purCompanyExceptionContent;

  /**
   * 票面信息异常备注
   */
  private String customRemark;

  /**
   * 源文件类型
   */
  private String originFileType;

  /**
   * 付款时间
   */
  private String paymentTime;

  /**
   * 部门名称
   */
  private String sectionName;

  /**
   * 认证任务id
   */
  private String authTaskId;

  /**
   * 认证错误码
   */
  private String authTaxErrorCode;


  /**
   * 对一关联关系 关联对象 invoiceMain
   */
    private Long invoiceViewAndInvoiceMainRelationId;
  /**
   * 对一关联关系 关联对象 invoiceVerify
   */
    private Long invoiceViewAndInvoiceVerifyRelationId;
  /**
   * 对一关联关系 关联对象 invoiceAuth
   */
    private Long invoiceViewAndInvoiceAuthRelationId;
  /**
   * 对一关联关系 关联对象 invoiceBusiness
   */
    private Long invoiceViewAndInvoiceBusinessRelationId;
  /**
   * 对一关联关系 关联对象 company
   */
    private Long companyAndInvoiceViewRelationId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("invoice_no", invoiceNo);
      map.put("invoice_code", invoiceCode);
      map.put("invoice_type", invoiceType);
      map.put("check_user_id", checkUserId);
      map.put("check_user_name", checkUserName);
      map.put("check_time", checkTime);
      map.put("auth_style", authStyle);
      map.put("auth_use", authUse);
      map.put("auth_remark", authRemark);
      map.put("auth_status", authStatus);
      map.put("effective_tax_amount", effectiveTaxAmount);
      map.put("no_auth_reason", noAuthReason);
      map.put("auth_bussi_date", authBussiDate);
      map.put("auth_tax_period", authTaxPeriod);
      map.put("invoice_status", invoiceStatus);
      map.put("invoice_orig", invoiceOrig);
      map.put("cooperate_flag", cooperateFlag);
      map.put("compliance_status", complianceStatus);
      map.put("retreat_status", retreatStatus);
      map.put("retreat_remark", retreatRemark);
      map.put("hang_status", hangStatus);
      map.put("hang_remark", hangRemark);
      map.put("sign_for_status", signForStatus);
      map.put("sign_for_time", signForTime);
      map.put("charge_up_status", chargeUpStatus);
      map.put("charge_up_period", chargeUpPeriod);
      map.put("charge_up_no", chargeUpNo);
      map.put("payment_status", paymentStatus);
      map.put("payment_no", paymentNo);
      map.put("payment_date", paymentDate);
      map.put("black_status", blackStatus);
      map.put("black_remark", blackRemark);
      map.put("turn_out_status", turnOutStatus);
      map.put("turn_out_amount", turnOutAmount);
      map.put("turn_out_period", turnOutPeriod);
      map.put("audit_status", auditStatus);
      map.put("audit_name", auditName);
      map.put("audit_remark", auditRemark);
      map.put("audit_time", auditTime);
      map.put("reserve_amount_without_tax", reserveAmountWithoutTax);
      map.put("reserve_tax_amount", reserveTaxAmount);
      map.put("reserve_amount_with_tax", reserveAmountWithTax);
      map.put("paper_drew_date", paperDrewDate);
      map.put("amount_without_tax", amountWithoutTax);
      map.put("tax_amount", taxAmount);
      map.put("amount_with_tax", amountWithTax);
      map.put("purchaser_name", purchaserName);
      map.put("purchaser_tax_no", purchaserTaxNo);
      map.put("seller_name", sellerName);
      map.put("seller_tax_no", sellerTaxNo);
      map.put("machine_code", machineCode);
      map.put("check_code", checkCode);
      map.put("cipher_text", cipherText);
      map.put("cashier_name", cashierName);
      map.put("checker_name", checkerName);
      map.put("invoicer_name", invoicerName);
      map.put("purchaser_addr_tel", purchaserAddrTel);
      map.put("purchaser_bank_name_account", purchaserBankNameAccount);
      map.put("seller_addr_tel", sellerAddrTel);
      map.put("seller_bank_name_account", sellerBankNameAccount);
      map.put("invoice_remark", invoiceRemark);
      map.put("origin_invoice_no", originInvoiceNo);
      map.put("origin_invoice_code", originInvoiceCode);
      map.put("issue_flag", issueFlag);
      map.put("issue_name", issueName);
      map.put("issue_tax_no", issueTaxNo);
      map.put("special_invoice_flag", specialInvoiceFlag);
      map.put("tenant_name", tenantName);
      map.put("sale_list_flag", saleListFlag);
      map.put("area_code", areaCode);
      map.put("area_name", areaName);
      map.put("org_id", orgId);
      map.put("verify_user_id", verifyUserId);
      map.put("verify_user_name", verifyUserName);
      map.put("verify_time", verifyTime);
      map.put("verify_number", verifyNumber);
      map.put("verify_remark", verifyRemark);
      map.put("verify_status", verifyStatus);
      map.put("verify_sign_status", verifySignStatus);
      map.put("tax_task_id", taxTaskId);
      map.put("data_status", dataStatus);
      map.put("invoice_color", invoiceColor);
      map.put("purchaser_company_id", purchaserCompanyId);
      map.put("purchaser_no", purchaserNo);
      map.put("invoice_business_type", invoiceBusinessType);
      map.put("turn_out_type", turnOutType);
      map.put("el_time", elTime);
      map.put("ext1", ext1);
      map.put("ext2", ext2);
      map.put("ext3", ext3);
      map.put("ext4", ext4);
      map.put("ext5", ext5);
      map.put("ext6", ext6);
      map.put("ext7", ext7);
      map.put("ext8", ext8);
      map.put("ext9", ext9);
      map.put("ext10", ext10);
      map.put("ext11", ext11);
      map.put("ext12", ext12);
      map.put("ext13", ext13);
      map.put("ext14", ext14);
      map.put("ext15", ext15);
      map.put("ext16", ext16);
      map.put("ext17", ext17);
      map.put("ext18", ext18);
      map.put("ext19", ext19);
      map.put("ext20", ext20);
      map.put("ext21", ext21);
      map.put("ext22", ext22);
      map.put("ext23", ext23);
      map.put("ext24", ext24);
      map.put("ext25", ext25);
      map.put("recog_time", recogTime);
      map.put("recog_status", recogStatus);
      map.put("match_status", matchStatus);
      map.put("match_time", matchTime);
      map.put("match_amount", matchAmount);
      map.put("org_code", orgCode);
      map.put("tax_rate", taxRate);
      map.put("all_electric_invoice_no", allElectricInvoiceNo);
      map.put("el_sync_flag", elSyncFlag);
      map.put("biz_order_no", bizOrderNo);
      map.put("is_check", isCheck);
      map.put("is_intercept", isIntercept);
      map.put("is_not_check", isNotCheck);
      map.put("is_offline_check", isOfflineCheck);
      map.put("is_auto_check", isAutoCheck);
      map.put("charge_up_amount", chargeUpAmount);
      map.put("payment_amount", paymentAmount);
      map.put("recog_user_name", recogUserName);
      map.put("invoice_category", invoiceCategory);
      map.put("area_type", areaType);
      map.put("recog_batch_no", recogBatchNo);
      map.put("is_cancel_check", isCancelCheck);
      map.put("purchaser_address", purchaserAddress);
      map.put("purchaser_tel", purchaserTel);
      map.put("purchaser_bank_name", purchaserBankName);
      map.put("purchaser_bank_account", purchaserBankAccount);
      map.put("seller_address", sellerAddress);
      map.put("seller_tel", sellerTel);
      map.put("seller_bank_name", sellerBankName);
      map.put("seller_bank_account", sellerBankAccount);
      map.put("sale_confirm_no", saleConfirmNo);
      map.put("sale_confirm_status", saleConfirmStatus);
      map.put("sale_confirm_period", saleConfirmPeriod);
      map.put("charge_up_person", chargeUpPerson);
      map.put("payment_batch_no", paymentBatchNo);
      map.put("payment_user_name", paymentUserName);
      map.put("report_status", reportStatus);
      map.put("report_no", reportNo);
      map.put("report_time", reportTime);
      map.put("reimbursement_status", reimbursementStatus);
      map.put("turn_out_remark", turnOutRemark);
      map.put("red_time", redTime);
      map.put("red_notification_no", redNotificationNo);
      map.put("red_status", redStatus);
      map.put("purchaser_external_code", purchaserExternalCode);
      map.put("seller_external_code", sellerExternalCode);
      map.put("org_name", orgName);
      map.put("system_source", systemSource);
      map.put("recog_order_no", recogOrderNo);
      map.put("retreat_time", retreatTime);
      map.put("ncp_type", ncpType);
      map.put("ncp_handle_type", ncpHandleType);
      map.put("ncp_handle_status", ncpHandleStatus);
      map.put("ncp_handle_time", ncpHandleTime);
      map.put("ncp_handle_user_name", ncpHandleUserName);
      map.put("ncp_handle_remark", ncpHandleRemark);
      map.put("ncp_part_amount", ncpPartAmount);
      map.put("entry_status", entryStatus);
      map.put("entry_time", entryTime);
      map.put("entry_user_name", entryUserName);
      map.put("entry_remark", entryRemark);
      map.put("entry_tab_status", entryTabStatus);
      map.put("ncp_manage_status", ncpManageStatus);
      map.put("no_compliance_type", noComplianceType);
      map.put("recog_user_id", recogUserId);
      map.put("follow_up_status", followUpStatus);
      map.put("risk_handle_status", riskHandleStatus);
      map.put("follow_up_remark", followUpRemark);
      map.put("hang_time", hangTime);
      map.put("hang_user", hangUser);
      map.put("exception_time", exceptionTime);
      map.put("exception_create_user", exceptionCreateUser);
      map.put("reopen_invoice_no", reopenInvoiceNo);
      map.put("reopen_invoice_code", reopenInvoiceCode);
      map.put("business_control_status", businessControlStatus);
      map.put("function_group", functionGroup);
      map.put("function_group_way", functionGroupWay);
      map.put("waybill_no", waybillNo);
      map.put("origin_all_electric_invoice_no", originAllElectricInvoiceNo);
      map.put("ext26", ext26);
      map.put("ext27", ext27);
      map.put("ext28", ext28);
      map.put("ext29", ext29);
      map.put("ext30", ext30);
      map.put("ext31", ext31);
      map.put("ext32", ext32);
      map.put("ext33", ext33);
      map.put("ext34", ext34);
      map.put("ext35", ext35);
      map.put("ext36", ext36);
      map.put("ext37", ext37);
      map.put("reverse_list", reverseList);
      map.put("ncp_jjkc_tax_amount", ncpJjkcTaxAmount);
      map.put("ncp_jjkc_left_tax_amount", ncpJjkcLeftTaxAmount);
      map.put("ncp_jjkc_current_tax_amount", ncpJjkcCurrentTaxAmount);
      map.put("ncp_jjkc_auth_use", ncpJjkcAuthUse);
      map.put("ncp_jjkc_submit_status", ncpJjkcSubmitStatus);
      map.put("ncp_jjkc_submit_remark", ncpJjkcSubmitRemark);
      map.put("ncp_jjkc_status", ncpJjkcStatus);
      map.put("recog_sheet", recogSheet);
      map.put("ncp_jjkc_submit_time", ncpJjkcSubmitTime);
      map.put("ncp_jjkc_accum_tax_amount", ncpJjkcAccumTaxAmount);
      map.put("is_cancelled_check", isCancelledCheck);
      map.put("biz_tag1", bizTag1);
      map.put("biz_tag2", bizTag2);
      map.put("biz_tag3", bizTag3);
      map.put("auth_request_time", authRequestTime);
      map.put("follow_up_user", followUpUser);
      map.put("follow_up_time", followUpTime);
      map.put("jv_pc", jvPc);
      map.put("jv_code", jvCode);
      map.put("store_code", storeCode);
      map.put("rms_code", rmsCode);
      map.put("list_import_user", listImportUser);
      map.put("list_import_time", listImportTime);
      map.put("market", market);
      map.put("area", area);
      map.put("un_certified_reason", unCertifiedReason);
      map.put("un_certified_remark", unCertifiedRemark);
      map.put("risk_invoice_category", riskInvoiceCategory);
      map.put("origin_biz_order_no", originBizOrderNo);
      map.put("is_repeat", isRepeat);
      map.put("is_need_auth", isNeedAuth);
      map.put("is_send_exception", isSendException);
      map.put("send_exception_remark", sendExceptionRemark);
      map.put("auth_cancel_time", authCancelTime);
      map.put("organization_code", organizationCode);
      map.put("vehicle_type", vehicleType);
      map.put("vehicle_brand", vehicleBrand);
      map.put("production_area", productionArea);
      map.put("cert_no", certNo);
      map.put("inspection_no", inspectionNo);
      map.put("engine_no", engineNo);
      map.put("vehicle_no", vehicleNo);
      map.put("tonnage", tonnage);
      map.put("max_capacity", maxCapacity);
      map.put("import_cert_no", importCertNo);
      map.put("tax_auth_name", taxAuthName);
      map.put("tax_auth_code", taxAuthCode);
      map.put("tax_paid_proof", taxPaidProof);
      map.put("is_tax_cancel_auth", isTaxCancelAuth);
      map.put("tax_cancel_auth_time", taxCancelAuthTime);
      map.put("actual_auth_way", actualAuthWay);
      map.put("seller_sync_time", sellerSyncTime);
      map.put("last_modify_time", lastModifyTime);
      map.put("seller_no", sellerNo);
      map.put("seller_company_id", sellerCompanyId);
      map.put("data_sharding", dataSharding);
      map.put("back_express_number", backExpressNumber);
      map.put("el_flag", elFlag);
      map.put("is_ledger_not_arrive", isLedgerNotArrive);
      map.put("auth_show_category", authShowCategory);
      map.put("biz_order_id", bizOrderId);
      map.put("outer_invoice_id", outerInvoiceId);
      map.put("seller_issued_status", sellerIssuedStatus);
      map.put("tax_rate_definition", taxRateDefinition);
      map.put("seller_tenant_id", sellerTenantId);
      map.put("customer_no", customerNo);
      map.put("recog_way", recogWay);
      map.put("business_tag", businessTag);
      map.put("risk_status", riskStatus);
      map.put("transfer_status", transferStatus);
      map.put("org_tree", orgTree);
      map.put("sense_word", senseWord);
      map.put("sense_word_level", senseWordLevel);
      map.put("pur_company_exception_content", purCompanyExceptionContent);
      map.put("custom_remark", customRemark);
      map.put("origin_file_type", originFileType);
      map.put("payment_time", paymentTime);
      map.put("section_name", sectionName);
      map.put("auth_task_id", authTaskId);
      map.put("auth_tax_error_code", authTaxErrorCode);

       map.put("invoiceViewAndInvoiceMainRelation.id", invoiceViewAndInvoiceMainRelationId);
       map.put("invoiceViewAndInvoiceVerifyRelation.id", invoiceViewAndInvoiceVerifyRelationId);
       map.put("invoiceViewAndInvoiceAuthRelation.id", invoiceViewAndInvoiceAuthRelationId);
       map.put("invoiceViewAndInvoiceBusinessRelation.id", invoiceViewAndInvoiceBusinessRelationId);
       map.put("companyAndInvoiceViewRelation.id", companyAndInvoiceViewRelationId);
      return map;
  }

  public static InvoiceView fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceView entity = new InvoiceView();
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_user_id")) {
      Object obj = map.get("check_user_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckUserId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_user_name")) {
      Object obj = map.get("check_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_time")) {
      Object obj = map.get("check_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_style")) {
      Object obj = map.get("auth_style");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuthStyle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_use")) {
      Object obj = map.get("auth_use");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuthUse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_remark")) {
      Object obj = map.get("auth_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuthRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_status")) {
      Object obj = map.get("auth_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuthStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("effective_tax_amount")) {
      Object obj = map.get("effective_tax_amount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEffectiveTaxAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("no_auth_reason")) {
      Object obj = map.get("no_auth_reason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNoAuthReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_bussi_date")) {
      Object obj = map.get("auth_bussi_date");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuthBussiDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_tax_period")) {
      Object obj = map.get("auth_tax_period");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuthTaxPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_status")) {
      Object obj = map.get("invoice_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_orig")) {
      Object obj = map.get("invoice_orig");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceOrig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cooperate_flag")) {
      Object obj = map.get("cooperate_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCooperateFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("compliance_status")) {
      Object obj = map.get("compliance_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setComplianceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retreat_status")) {
      Object obj = map.get("retreat_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRetreatStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retreat_remark")) {
      Object obj = map.get("retreat_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRetreatRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hang_status")) {
      Object obj = map.get("hang_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHangStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hang_remark")) {
      Object obj = map.get("hang_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHangRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sign_for_status")) {
      Object obj = map.get("sign_for_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSignForStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sign_for_time")) {
      Object obj = map.get("sign_for_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSignForTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_up_status")) {
      Object obj = map.get("charge_up_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeUpStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_up_period")) {
      Object obj = map.get("charge_up_period");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeUpPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_up_no")) {
      Object obj = map.get("charge_up_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeUpNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payment_status")) {
      Object obj = map.get("payment_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payment_no")) {
      Object obj = map.get("payment_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payment_date")) {
      Object obj = map.get("payment_date");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("black_status")) {
      Object obj = map.get("black_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBlackStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("black_remark")) {
      Object obj = map.get("black_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBlackRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("turn_out_status")) {
      Object obj = map.get("turn_out_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTurnOutStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("turn_out_amount")) {
      Object obj = map.get("turn_out_amount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTurnOutAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("turn_out_period")) {
      Object obj = map.get("turn_out_period");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTurnOutPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("audit_status")) {
      Object obj = map.get("audit_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuditStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("audit_name")) {
      Object obj = map.get("audit_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuditName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("audit_remark")) {
      Object obj = map.get("audit_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuditRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("audit_time")) {
      Object obj = map.get("audit_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuditTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reserve_amount_without_tax")) {
      Object obj = map.get("reserve_amount_without_tax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReserveAmountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reserve_tax_amount")) {
      Object obj = map.get("reserve_tax_amount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReserveTaxAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reserve_amount_with_tax")) {
      Object obj = map.get("reserve_amount_with_tax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReserveAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paper_drew_date")) {
      Object obj = map.get("paper_drew_date");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaperDrewDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAmountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_name")) {
      Object obj = map.get("purchaser_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("machine_code")) {
      Object obj = map.get("machine_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMachineCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_code")) {
      Object obj = map.get("check_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cipher_text")) {
      Object obj = map.get("cipher_text");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCipherText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cashier_name")) {
      Object obj = map.get("cashier_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCashierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checker_name")) {
      Object obj = map.get("checker_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicer_name")) {
      Object obj = map.get("invoicer_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoicerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_addr_tel")) {
      Object obj = map.get("purchaser_addr_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_bank_name_account")) {
      Object obj = map.get("purchaser_bank_name_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankNameAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_addr_tel")) {
      Object obj = map.get("seller_addr_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_bank_name_account")) {
      Object obj = map.get("seller_bank_name_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankNameAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_remark")) {
      Object obj = map.get("invoice_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origin_invoice_no")) {
      Object obj = map.get("origin_invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origin_invoice_code")) {
      Object obj = map.get("origin_invoice_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("issue_flag")) {
      Object obj = map.get("issue_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIssueFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("issue_name")) {
      Object obj = map.get("issue_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIssueName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("issue_tax_no")) {
      Object obj = map.get("issue_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIssueTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("special_invoice_flag")) {
      Object obj = map.get("special_invoice_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpecialInvoiceFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenant_name")) {
      Object obj = map.get("tenant_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sale_list_flag")) {
      Object obj = map.get("sale_list_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSaleListFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("area_code")) {
      Object obj = map.get("area_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAreaCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("area_name")) {
      Object obj = map.get("area_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAreaName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verify_user_id")) {
      Object obj = map.get("verify_user_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVerifyUserId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verify_user_name")) {
      Object obj = map.get("verify_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVerifyUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verify_time")) {
      Object obj = map.get("verify_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVerifyTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verify_number")) {
      Object obj = map.get("verify_number");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVerifyNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verify_remark")) {
      Object obj = map.get("verify_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVerifyRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verify_status")) {
      Object obj = map.get("verify_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVerifyStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verify_sign_status")) {
      Object obj = map.get("verify_sign_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVerifySignStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_task_id")) {
      Object obj = map.get("tax_task_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxTaskId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("data_status")) {
      Object obj = map.get("data_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_color")) {
      Object obj = map.get("invoice_color");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceColor((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_company_id")) {
      Object obj = map.get("purchaser_company_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserCompanyId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_no")) {
      Object obj = map.get("purchaser_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_business_type")) {
      Object obj = map.get("invoice_business_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("turn_out_type")) {
      Object obj = map.get("turn_out_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTurnOutType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("el_time")) {
      Object obj = map.get("el_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setElTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext11")) {
      Object obj = map.get("ext11");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt11((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext12")) {
      Object obj = map.get("ext12");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt12((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext13")) {
      Object obj = map.get("ext13");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt13((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext14")) {
      Object obj = map.get("ext14");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt14((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext15")) {
      Object obj = map.get("ext15");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt15((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext16")) {
      Object obj = map.get("ext16");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt16((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext17")) {
      Object obj = map.get("ext17");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt17((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext18")) {
      Object obj = map.get("ext18");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt18((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext19")) {
      Object obj = map.get("ext19");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt19((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext20")) {
      Object obj = map.get("ext20");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt20((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext21")) {
      Object obj = map.get("ext21");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt21((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext22")) {
      Object obj = map.get("ext22");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt22((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext23")) {
      Object obj = map.get("ext23");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt23((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext24")) {
      Object obj = map.get("ext24");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt24((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext25")) {
      Object obj = map.get("ext25");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt25((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recog_time")) {
      Object obj = map.get("recog_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecogTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recog_status")) {
      Object obj = map.get("recog_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecogStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("match_status")) {
      Object obj = map.get("match_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMatchStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("match_time")) {
      Object obj = map.get("match_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMatchTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("match_amount")) {
      Object obj = map.get("match_amount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMatchAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_code")) {
      Object obj = map.get("org_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("all_electric_invoice_no")) {
      Object obj = map.get("all_electric_invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAllElectricInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("el_sync_flag")) {
      Object obj = map.get("el_sync_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setElSyncFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("biz_order_no")) {
      Object obj = map.get("biz_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_check")) {
      Object obj = map.get("is_check");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsCheck((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_intercept")) {
      Object obj = map.get("is_intercept");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsIntercept((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_not_check")) {
      Object obj = map.get("is_not_check");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsNotCheck((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_offline_check")) {
      Object obj = map.get("is_offline_check");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsOfflineCheck((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_auto_check")) {
      Object obj = map.get("is_auto_check");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsAutoCheck((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_up_amount")) {
      Object obj = map.get("charge_up_amount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeUpAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payment_amount")) {
      Object obj = map.get("payment_amount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recog_user_name")) {
      Object obj = map.get("recog_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecogUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_category")) {
      Object obj = map.get("invoice_category");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("area_type")) {
      Object obj = map.get("area_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAreaType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recog_batch_no")) {
      Object obj = map.get("recog_batch_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecogBatchNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_cancel_check")) {
      Object obj = map.get("is_cancel_check");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsCancelCheck((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_address")) {
      Object obj = map.get("purchaser_address");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tel")) {
      Object obj = map.get("purchaser_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_bank_name")) {
      Object obj = map.get("purchaser_bank_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_bank_account")) {
      Object obj = map.get("purchaser_bank_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_address")) {
      Object obj = map.get("seller_address");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tel")) {
      Object obj = map.get("seller_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_bank_name")) {
      Object obj = map.get("seller_bank_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_bank_account")) {
      Object obj = map.get("seller_bank_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sale_confirm_no")) {
      Object obj = map.get("sale_confirm_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSaleConfirmNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sale_confirm_status")) {
      Object obj = map.get("sale_confirm_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSaleConfirmStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sale_confirm_period")) {
      Object obj = map.get("sale_confirm_period");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSaleConfirmPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_up_person")) {
      Object obj = map.get("charge_up_person");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeUpPerson((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payment_batch_no")) {
      Object obj = map.get("payment_batch_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentBatchNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payment_user_name")) {
      Object obj = map.get("payment_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("report_status")) {
      Object obj = map.get("report_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReportStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("report_no")) {
      Object obj = map.get("report_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReportNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("report_time")) {
      Object obj = map.get("report_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReportTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reimbursement_status")) {
      Object obj = map.get("reimbursement_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReimbursementStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("turn_out_remark")) {
      Object obj = map.get("turn_out_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTurnOutRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("red_time")) {
      Object obj = map.get("red_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("red_notification_no")) {
      Object obj = map.get("red_notification_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedNotificationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("red_status")) {
      Object obj = map.get("red_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_external_code")) {
      Object obj = map.get("purchaser_external_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserExternalCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_external_code")) {
      Object obj = map.get("seller_external_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerExternalCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_name")) {
      Object obj = map.get("org_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("system_source")) {
      Object obj = map.get("system_source");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSystemSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recog_order_no")) {
      Object obj = map.get("recog_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecogOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retreat_time")) {
      Object obj = map.get("retreat_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRetreatTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_type")) {
      Object obj = map.get("ncp_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNcpType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_handle_type")) {
      Object obj = map.get("ncp_handle_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNcpHandleType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_handle_status")) {
      Object obj = map.get("ncp_handle_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNcpHandleStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_handle_time")) {
      Object obj = map.get("ncp_handle_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNcpHandleTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_handle_user_name")) {
      Object obj = map.get("ncp_handle_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNcpHandleUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_handle_remark")) {
      Object obj = map.get("ncp_handle_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNcpHandleRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_part_amount")) {
      Object obj = map.get("ncp_part_amount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNcpPartAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("entry_status")) {
      Object obj = map.get("entry_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEntryStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("entry_time")) {
      Object obj = map.get("entry_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEntryTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("entry_user_name")) {
      Object obj = map.get("entry_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEntryUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("entry_remark")) {
      Object obj = map.get("entry_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEntryRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("entry_tab_status")) {
      Object obj = map.get("entry_tab_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEntryTabStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_manage_status")) {
      Object obj = map.get("ncp_manage_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNcpManageStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("no_compliance_type")) {
      Object obj = map.get("no_compliance_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNoComplianceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recog_user_id")) {
      Object obj = map.get("recog_user_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecogUserId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("follow_up_status")) {
      Object obj = map.get("follow_up_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFollowUpStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("risk_handle_status")) {
      Object obj = map.get("risk_handle_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRiskHandleStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("follow_up_remark")) {
      Object obj = map.get("follow_up_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFollowUpRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hang_time")) {
      Object obj = map.get("hang_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHangTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hang_user")) {
      Object obj = map.get("hang_user");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHangUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_time")) {
      Object obj = map.get("exception_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExceptionTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_create_user")) {
      Object obj = map.get("exception_create_user");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExceptionCreateUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reopen_invoice_no")) {
      Object obj = map.get("reopen_invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReopenInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reopen_invoice_code")) {
      Object obj = map.get("reopen_invoice_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReopenInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_control_status")) {
      Object obj = map.get("business_control_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessControlStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("function_group")) {
      Object obj = map.get("function_group");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFunctionGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("function_group_way")) {
      Object obj = map.get("function_group_way");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFunctionGroupWay((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("waybill_no")) {
      Object obj = map.get("waybill_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWaybillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origin_all_electric_invoice_no")) {
      Object obj = map.get("origin_all_electric_invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginAllElectricInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext26")) {
      Object obj = map.get("ext26");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt26((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext27")) {
      Object obj = map.get("ext27");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt27((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext28")) {
      Object obj = map.get("ext28");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt28((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext29")) {
      Object obj = map.get("ext29");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt29((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext30")) {
      Object obj = map.get("ext30");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt30((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext31")) {
      Object obj = map.get("ext31");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt31((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext32")) {
      Object obj = map.get("ext32");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt32((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext33")) {
      Object obj = map.get("ext33");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt33((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext34")) {
      Object obj = map.get("ext34");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt34((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext35")) {
      Object obj = map.get("ext35");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt35((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext36")) {
      Object obj = map.get("ext36");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt36((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext37")) {
      Object obj = map.get("ext37");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt37((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reverse_list")) {
      Object obj = map.get("reverse_list");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReverseList((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_jjkc_tax_amount")) {
      Object obj = map.get("ncp_jjkc_tax_amount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNcpJjkcTaxAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_jjkc_left_tax_amount")) {
      Object obj = map.get("ncp_jjkc_left_tax_amount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNcpJjkcLeftTaxAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_jjkc_current_tax_amount")) {
      Object obj = map.get("ncp_jjkc_current_tax_amount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNcpJjkcCurrentTaxAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_jjkc_auth_use")) {
      Object obj = map.get("ncp_jjkc_auth_use");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNcpJjkcAuthUse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_jjkc_submit_status")) {
      Object obj = map.get("ncp_jjkc_submit_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNcpJjkcSubmitStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_jjkc_submit_remark")) {
      Object obj = map.get("ncp_jjkc_submit_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNcpJjkcSubmitRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_jjkc_status")) {
      Object obj = map.get("ncp_jjkc_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNcpJjkcStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recog_sheet")) {
      Object obj = map.get("recog_sheet");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecogSheet((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_jjkc_submit_time")) {
      Object obj = map.get("ncp_jjkc_submit_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNcpJjkcSubmitTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncp_jjkc_accum_tax_amount")) {
      Object obj = map.get("ncp_jjkc_accum_tax_amount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNcpJjkcAccumTaxAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_cancelled_check")) {
      Object obj = map.get("is_cancelled_check");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsCancelledCheck((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("biz_tag1")) {
      Object obj = map.get("biz_tag1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizTag1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("biz_tag2")) {
      Object obj = map.get("biz_tag2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizTag2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("biz_tag3")) {
      Object obj = map.get("biz_tag3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizTag3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_request_time")) {
      Object obj = map.get("auth_request_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuthRequestTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("follow_up_user")) {
      Object obj = map.get("follow_up_user");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFollowUpUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("follow_up_time")) {
      Object obj = map.get("follow_up_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFollowUpTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jv_pc")) {
      Object obj = map.get("jv_pc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJvPc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jv_code")) {
      Object obj = map.get("jv_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJvCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("store_code")) {
      Object obj = map.get("store_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rms_code")) {
      Object obj = map.get("rms_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRmsCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("list_import_user")) {
      Object obj = map.get("list_import_user");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setListImportUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("list_import_time")) {
      Object obj = map.get("list_import_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setListImportTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("market")) {
      Object obj = map.get("market");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMarket((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("area")) {
      Object obj = map.get("area");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setArea((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("un_certified_reason")) {
      Object obj = map.get("un_certified_reason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnCertifiedReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("un_certified_remark")) {
      Object obj = map.get("un_certified_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnCertifiedRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("risk_invoice_category")) {
      Object obj = map.get("risk_invoice_category");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRiskInvoiceCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origin_biz_order_no")) {
      Object obj = map.get("origin_biz_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginBizOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_repeat")) {
      Object obj = map.get("is_repeat");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsRepeat((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_need_auth")) {
      Object obj = map.get("is_need_auth");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsNeedAuth((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_send_exception")) {
      Object obj = map.get("is_send_exception");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsSendException((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("send_exception_remark")) {
      Object obj = map.get("send_exception_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSendExceptionRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_cancel_time")) {
      Object obj = map.get("auth_cancel_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuthCancelTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("organization_code")) {
      Object obj = map.get("organization_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrganizationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vehicle_type")) {
      Object obj = map.get("vehicle_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVehicleType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vehicle_brand")) {
      Object obj = map.get("vehicle_brand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVehicleBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("production_area")) {
      Object obj = map.get("production_area");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductionArea((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cert_no")) {
      Object obj = map.get("cert_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCertNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("inspection_no")) {
      Object obj = map.get("inspection_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInspectionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("engine_no")) {
      Object obj = map.get("engine_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEngineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vehicle_no")) {
      Object obj = map.get("vehicle_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVehicleNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tonnage")) {
      Object obj = map.get("tonnage");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTonnage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("max_capacity")) {
      Object obj = map.get("max_capacity");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMaxCapacity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("import_cert_no")) {
      Object obj = map.get("import_cert_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setImportCertNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_auth_name")) {
      Object obj = map.get("tax_auth_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxAuthName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_auth_code")) {
      Object obj = map.get("tax_auth_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxAuthCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_paid_proof")) {
      Object obj = map.get("tax_paid_proof");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxPaidProof((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_tax_cancel_auth")) {
      Object obj = map.get("is_tax_cancel_auth");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsTaxCancelAuth((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_cancel_auth_time")) {
      Object obj = map.get("tax_cancel_auth_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxCancelAuthTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("actual_auth_way")) {
      Object obj = map.get("actual_auth_way");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setActualAuthWay((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_sync_time")) {
      Object obj = map.get("seller_sync_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerSyncTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("last_modify_time")) {
      Object obj = map.get("last_modify_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLastModifyTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_no")) {
      Object obj = map.get("seller_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_company_id")) {
      Object obj = map.get("seller_company_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCompanyId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("data_sharding")) {
      Object obj = map.get("data_sharding");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataSharding((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("back_express_number")) {
      Object obj = map.get("back_express_number");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBackExpressNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("el_flag")) {
      Object obj = map.get("el_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setElFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_ledger_not_arrive")) {
      Object obj = map.get("is_ledger_not_arrive");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsLedgerNotArrive((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_show_category")) {
      Object obj = map.get("auth_show_category");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuthShowCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("biz_order_id")) {
      Object obj = map.get("biz_order_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("outer_invoice_id")) {
      Object obj = map.get("outer_invoice_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOuterInvoiceId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_issued_status")) {
      Object obj = map.get("seller_issued_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerIssuedStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_rate_definition")) {
      Object obj = map.get("tax_rate_definition");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxRateDefinition((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tenant_id")) {
      Object obj = map.get("seller_tenant_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTenantId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer_no")) {
      Object obj = map.get("customer_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recog_way")) {
      Object obj = map.get("recog_way");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecogWay((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_tag")) {
      Object obj = map.get("business_tag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessTag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("risk_status")) {
      Object obj = map.get("risk_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRiskStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("transfer_status")) {
      Object obj = map.get("transfer_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTransferStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sense_word")) {
      Object obj = map.get("sense_word");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSenseWord((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sense_word_level")) {
      Object obj = map.get("sense_word_level");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSenseWordLevel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pur_company_exception_content")) {
      Object obj = map.get("pur_company_exception_content");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurCompanyExceptionContent((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("custom_remark")) {
      Object obj = map.get("custom_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origin_file_type")) {
      Object obj = map.get("origin_file_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginFileType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payment_time")) {
      Object obj = map.get("payment_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("section_name")) {
      Object obj = map.get("section_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSectionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_task_id")) {
      Object obj = map.get("auth_task_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuthTaskId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_tax_error_code")) {
      Object obj = map.get("auth_tax_error_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuthTaxErrorCode((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("invoiceViewAndInvoiceMainRelation.id")) {
        Object obj = map.get("invoiceViewAndInvoiceMainRelation.id");
      if(obj instanceof Long) {
        entity.setInvoiceViewAndInvoiceMainRelationId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setInvoiceViewAndInvoiceMainRelationId(Long.parseLong((String)obj));
      }
    }
    if(map.containsKey("invoiceViewAndInvoiceVerifyRelation.id")) {
        Object obj = map.get("invoiceViewAndInvoiceVerifyRelation.id");
      if(obj instanceof Long) {
        entity.setInvoiceViewAndInvoiceVerifyRelationId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setInvoiceViewAndInvoiceVerifyRelationId(Long.parseLong((String)obj));
      }
    }
    if(map.containsKey("invoiceViewAndInvoiceAuthRelation.id")) {
        Object obj = map.get("invoiceViewAndInvoiceAuthRelation.id");
      if(obj instanceof Long) {
        entity.setInvoiceViewAndInvoiceAuthRelationId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setInvoiceViewAndInvoiceAuthRelationId(Long.parseLong((String)obj));
      }
    }
    if(map.containsKey("invoiceViewAndInvoiceBusinessRelation.id")) {
        Object obj = map.get("invoiceViewAndInvoiceBusinessRelation.id");
      if(obj instanceof Long) {
        entity.setInvoiceViewAndInvoiceBusinessRelationId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setInvoiceViewAndInvoiceBusinessRelationId(Long.parseLong((String)obj));
      }
    }
    if(map.containsKey("companyAndInvoiceViewRelation.id")) {
        Object obj = map.get("companyAndInvoiceViewRelation.id");
      if(obj instanceof Long) {
        entity.setCompanyAndInvoiceViewRelationId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setCompanyAndInvoiceViewRelationId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("check_user_id")) {
      Object obj = map.get("check_user_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckUserId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("check_user_name")) {
      Object obj = map.get("check_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("check_time")) {
      Object obj = map.get("check_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auth_style")) {
      Object obj = map.get("auth_style");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthStyle((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auth_use")) {
      Object obj = map.get("auth_use");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthUse((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auth_remark")) {
      Object obj = map.get("auth_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auth_status")) {
      Object obj = map.get("auth_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("effective_tax_amount")) {
      Object obj = map.get("effective_tax_amount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEffectiveTaxAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("no_auth_reason")) {
      Object obj = map.get("no_auth_reason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNoAuthReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auth_bussi_date")) {
      Object obj = map.get("auth_bussi_date");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthBussiDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auth_tax_period")) {
      Object obj = map.get("auth_tax_period");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthTaxPeriod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_status")) {
      Object obj = map.get("invoice_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_orig")) {
      Object obj = map.get("invoice_orig");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceOrig((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cooperate_flag")) {
      Object obj = map.get("cooperate_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCooperateFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("compliance_status")) {
      Object obj = map.get("compliance_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setComplianceStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("retreat_status")) {
      Object obj = map.get("retreat_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRetreatStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("retreat_remark")) {
      Object obj = map.get("retreat_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRetreatRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("hang_status")) {
      Object obj = map.get("hang_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHangStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("hang_remark")) {
      Object obj = map.get("hang_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHangRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sign_for_status")) {
      Object obj = map.get("sign_for_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSignForStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sign_for_time")) {
      Object obj = map.get("sign_for_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSignForTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("charge_up_status")) {
      Object obj = map.get("charge_up_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeUpStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("charge_up_period")) {
      Object obj = map.get("charge_up_period");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeUpPeriod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("charge_up_no")) {
      Object obj = map.get("charge_up_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeUpNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payment_status")) {
      Object obj = map.get("payment_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payment_no")) {
      Object obj = map.get("payment_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payment_date")) {
      Object obj = map.get("payment_date");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("black_status")) {
      Object obj = map.get("black_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBlackStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("black_remark")) {
      Object obj = map.get("black_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBlackRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("turn_out_status")) {
      Object obj = map.get("turn_out_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTurnOutStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("turn_out_amount")) {
      Object obj = map.get("turn_out_amount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTurnOutAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("turn_out_period")) {
      Object obj = map.get("turn_out_period");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTurnOutPeriod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("audit_status")) {
      Object obj = map.get("audit_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuditStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("audit_name")) {
      Object obj = map.get("audit_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuditName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("audit_remark")) {
      Object obj = map.get("audit_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuditRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("audit_time")) {
      Object obj = map.get("audit_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuditTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reserve_amount_without_tax")) {
      Object obj = map.get("reserve_amount_without_tax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReserveAmountWithoutTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reserve_tax_amount")) {
      Object obj = map.get("reserve_tax_amount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReserveTaxAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reserve_amount_with_tax")) {
      Object obj = map.get("reserve_amount_with_tax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReserveAmountWithTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paper_drew_date")) {
      Object obj = map.get("paper_drew_date");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaperDrewDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAmountWithoutTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAmountWithTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_name")) {
      Object obj = map.get("purchaser_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("machine_code")) {
      Object obj = map.get("machine_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMachineCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("check_code")) {
      Object obj = map.get("check_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cipher_text")) {
      Object obj = map.get("cipher_text");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCipherText((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cashier_name")) {
      Object obj = map.get("cashier_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCashierName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("checker_name")) {
      Object obj = map.get("checker_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoicer_name")) {
      Object obj = map.get("invoicer_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoicerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_addr_tel")) {
      Object obj = map.get("purchaser_addr_tel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserAddrTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_bank_name_account")) {
      Object obj = map.get("purchaser_bank_name_account");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankNameAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_addr_tel")) {
      Object obj = map.get("seller_addr_tel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerAddrTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_bank_name_account")) {
      Object obj = map.get("seller_bank_name_account");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankNameAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_remark")) {
      Object obj = map.get("invoice_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("origin_invoice_no")) {
      Object obj = map.get("origin_invoice_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("origin_invoice_code")) {
      Object obj = map.get("origin_invoice_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("issue_flag")) {
      Object obj = map.get("issue_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIssueFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("issue_name")) {
      Object obj = map.get("issue_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIssueName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("issue_tax_no")) {
      Object obj = map.get("issue_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIssueTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("special_invoice_flag")) {
      Object obj = map.get("special_invoice_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSpecialInvoiceFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tenant_name")) {
      Object obj = map.get("tenant_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sale_list_flag")) {
      Object obj = map.get("sale_list_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSaleListFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("area_code")) {
      Object obj = map.get("area_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAreaCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("area_name")) {
      Object obj = map.get("area_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAreaName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("verify_user_id")) {
      Object obj = map.get("verify_user_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVerifyUserId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("verify_user_name")) {
      Object obj = map.get("verify_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVerifyUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("verify_time")) {
      Object obj = map.get("verify_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVerifyTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("verify_number")) {
      Object obj = map.get("verify_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVerifyNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("verify_remark")) {
      Object obj = map.get("verify_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVerifyRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("verify_status")) {
      Object obj = map.get("verify_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVerifyStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("verify_sign_status")) {
      Object obj = map.get("verify_sign_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVerifySignStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_task_id")) {
      Object obj = map.get("tax_task_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxTaskId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("data_status")) {
      Object obj = map.get("data_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDataStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_color")) {
      Object obj = map.get("invoice_color");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceColor((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_company_id")) {
      Object obj = map.get("purchaser_company_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserCompanyId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_no")) {
      Object obj = map.get("purchaser_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_business_type")) {
      Object obj = map.get("invoice_business_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceBusinessType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("turn_out_type")) {
      Object obj = map.get("turn_out_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTurnOutType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("el_time")) {
      Object obj = map.get("el_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setElTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt6((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt7((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt8((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt9((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt10((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext11")) {
      Object obj = map.get("ext11");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt11((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext12")) {
      Object obj = map.get("ext12");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt12((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext13")) {
      Object obj = map.get("ext13");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt13((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext14")) {
      Object obj = map.get("ext14");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt14((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext15")) {
      Object obj = map.get("ext15");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt15((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext16")) {
      Object obj = map.get("ext16");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt16((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext17")) {
      Object obj = map.get("ext17");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt17((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext18")) {
      Object obj = map.get("ext18");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt18((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext19")) {
      Object obj = map.get("ext19");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt19((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext20")) {
      Object obj = map.get("ext20");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt20((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext21")) {
      Object obj = map.get("ext21");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt21((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext22")) {
      Object obj = map.get("ext22");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt22((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext23")) {
      Object obj = map.get("ext23");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt23((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext24")) {
      Object obj = map.get("ext24");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt24((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext25")) {
      Object obj = map.get("ext25");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt25((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("recog_time")) {
      Object obj = map.get("recog_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecogTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("recog_status")) {
      Object obj = map.get("recog_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecogStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("match_status")) {
      Object obj = map.get("match_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMatchStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("match_time")) {
      Object obj = map.get("match_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMatchTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("match_amount")) {
      Object obj = map.get("match_amount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMatchAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_code")) {
      Object obj = map.get("org_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxRate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("all_electric_invoice_no")) {
      Object obj = map.get("all_electric_invoice_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAllElectricInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("el_sync_flag")) {
      Object obj = map.get("el_sync_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setElSyncFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("biz_order_no")) {
      Object obj = map.get("biz_order_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_check")) {
      Object obj = map.get("is_check");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsCheck((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_intercept")) {
      Object obj = map.get("is_intercept");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsIntercept((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_not_check")) {
      Object obj = map.get("is_not_check");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsNotCheck((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_offline_check")) {
      Object obj = map.get("is_offline_check");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsOfflineCheck((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_auto_check")) {
      Object obj = map.get("is_auto_check");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsAutoCheck((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("charge_up_amount")) {
      Object obj = map.get("charge_up_amount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeUpAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payment_amount")) {
      Object obj = map.get("payment_amount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("recog_user_name")) {
      Object obj = map.get("recog_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecogUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_category")) {
      Object obj = map.get("invoice_category");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceCategory((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("area_type")) {
      Object obj = map.get("area_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAreaType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("recog_batch_no")) {
      Object obj = map.get("recog_batch_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecogBatchNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_cancel_check")) {
      Object obj = map.get("is_cancel_check");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsCancelCheck((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_address")) {
      Object obj = map.get("purchaser_address");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_tel")) {
      Object obj = map.get("purchaser_tel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_bank_name")) {
      Object obj = map.get("purchaser_bank_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_bank_account")) {
      Object obj = map.get("purchaser_bank_account");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_address")) {
      Object obj = map.get("seller_address");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_tel")) {
      Object obj = map.get("seller_tel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_bank_name")) {
      Object obj = map.get("seller_bank_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_bank_account")) {
      Object obj = map.get("seller_bank_account");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sale_confirm_no")) {
      Object obj = map.get("sale_confirm_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSaleConfirmNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sale_confirm_status")) {
      Object obj = map.get("sale_confirm_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSaleConfirmStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sale_confirm_period")) {
      Object obj = map.get("sale_confirm_period");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSaleConfirmPeriod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("charge_up_person")) {
      Object obj = map.get("charge_up_person");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeUpPerson((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payment_batch_no")) {
      Object obj = map.get("payment_batch_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentBatchNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payment_user_name")) {
      Object obj = map.get("payment_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("report_status")) {
      Object obj = map.get("report_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReportStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("report_no")) {
      Object obj = map.get("report_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReportNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("report_time")) {
      Object obj = map.get("report_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReportTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reimbursement_status")) {
      Object obj = map.get("reimbursement_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReimbursementStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("turn_out_remark")) {
      Object obj = map.get("turn_out_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTurnOutRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("red_time")) {
      Object obj = map.get("red_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRedTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("red_notification_no")) {
      Object obj = map.get("red_notification_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRedNotificationNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("red_status")) {
      Object obj = map.get("red_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRedStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_external_code")) {
      Object obj = map.get("purchaser_external_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserExternalCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_external_code")) {
      Object obj = map.get("seller_external_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerExternalCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_name")) {
      Object obj = map.get("org_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("system_source")) {
      Object obj = map.get("system_source");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSystemSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("recog_order_no")) {
      Object obj = map.get("recog_order_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecogOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("retreat_time")) {
      Object obj = map.get("retreat_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRetreatTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ncp_type")) {
      Object obj = map.get("ncp_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNcpType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ncp_handle_type")) {
      Object obj = map.get("ncp_handle_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNcpHandleType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ncp_handle_status")) {
      Object obj = map.get("ncp_handle_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNcpHandleStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ncp_handle_time")) {
      Object obj = map.get("ncp_handle_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNcpHandleTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ncp_handle_user_name")) {
      Object obj = map.get("ncp_handle_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNcpHandleUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ncp_handle_remark")) {
      Object obj = map.get("ncp_handle_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNcpHandleRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ncp_part_amount")) {
      Object obj = map.get("ncp_part_amount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNcpPartAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("entry_status")) {
      Object obj = map.get("entry_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEntryStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("entry_time")) {
      Object obj = map.get("entry_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEntryTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("entry_user_name")) {
      Object obj = map.get("entry_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEntryUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("entry_remark")) {
      Object obj = map.get("entry_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEntryRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("entry_tab_status")) {
      Object obj = map.get("entry_tab_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEntryTabStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ncp_manage_status")) {
      Object obj = map.get("ncp_manage_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNcpManageStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("no_compliance_type")) {
      Object obj = map.get("no_compliance_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNoComplianceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("recog_user_id")) {
      Object obj = map.get("recog_user_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecogUserId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("follow_up_status")) {
      Object obj = map.get("follow_up_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFollowUpStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("risk_handle_status")) {
      Object obj = map.get("risk_handle_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRiskHandleStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("follow_up_remark")) {
      Object obj = map.get("follow_up_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFollowUpRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("hang_time")) {
      Object obj = map.get("hang_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHangTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("hang_user")) {
      Object obj = map.get("hang_user");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHangUser((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("exception_time")) {
      Object obj = map.get("exception_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExceptionTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("exception_create_user")) {
      Object obj = map.get("exception_create_user");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExceptionCreateUser((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reopen_invoice_no")) {
      Object obj = map.get("reopen_invoice_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReopenInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reopen_invoice_code")) {
      Object obj = map.get("reopen_invoice_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReopenInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("business_control_status")) {
      Object obj = map.get("business_control_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessControlStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("function_group")) {
      Object obj = map.get("function_group");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFunctionGroup((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("function_group_way")) {
      Object obj = map.get("function_group_way");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFunctionGroupWay((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("waybill_no")) {
      Object obj = map.get("waybill_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWaybillNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("origin_all_electric_invoice_no")) {
      Object obj = map.get("origin_all_electric_invoice_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginAllElectricInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext26")) {
      Object obj = map.get("ext26");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt26((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext27")) {
      Object obj = map.get("ext27");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt27((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext28")) {
      Object obj = map.get("ext28");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt28((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext29")) {
      Object obj = map.get("ext29");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt29((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext30")) {
      Object obj = map.get("ext30");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt30((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext31")) {
      Object obj = map.get("ext31");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt31((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext32")) {
      Object obj = map.get("ext32");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt32((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext33")) {
      Object obj = map.get("ext33");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt33((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext34")) {
      Object obj = map.get("ext34");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt34((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext35")) {
      Object obj = map.get("ext35");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt35((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext36")) {
      Object obj = map.get("ext36");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt36((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext37")) {
      Object obj = map.get("ext37");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt37((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reverse_list")) {
      Object obj = map.get("reverse_list");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReverseList((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ncp_jjkc_tax_amount")) {
      Object obj = map.get("ncp_jjkc_tax_amount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNcpJjkcTaxAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ncp_jjkc_left_tax_amount")) {
      Object obj = map.get("ncp_jjkc_left_tax_amount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNcpJjkcLeftTaxAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ncp_jjkc_current_tax_amount")) {
      Object obj = map.get("ncp_jjkc_current_tax_amount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNcpJjkcCurrentTaxAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ncp_jjkc_auth_use")) {
      Object obj = map.get("ncp_jjkc_auth_use");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNcpJjkcAuthUse((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ncp_jjkc_submit_status")) {
      Object obj = map.get("ncp_jjkc_submit_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNcpJjkcSubmitStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ncp_jjkc_submit_remark")) {
      Object obj = map.get("ncp_jjkc_submit_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNcpJjkcSubmitRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ncp_jjkc_status")) {
      Object obj = map.get("ncp_jjkc_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNcpJjkcStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("recog_sheet")) {
      Object obj = map.get("recog_sheet");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecogSheet((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ncp_jjkc_submit_time")) {
      Object obj = map.get("ncp_jjkc_submit_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNcpJjkcSubmitTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ncp_jjkc_accum_tax_amount")) {
      Object obj = map.get("ncp_jjkc_accum_tax_amount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNcpJjkcAccumTaxAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_cancelled_check")) {
      Object obj = map.get("is_cancelled_check");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsCancelledCheck((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("biz_tag1")) {
      Object obj = map.get("biz_tag1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizTag1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("biz_tag2")) {
      Object obj = map.get("biz_tag2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizTag2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("biz_tag3")) {
      Object obj = map.get("biz_tag3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizTag3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auth_request_time")) {
      Object obj = map.get("auth_request_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthRequestTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("follow_up_user")) {
      Object obj = map.get("follow_up_user");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFollowUpUser((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("follow_up_time")) {
      Object obj = map.get("follow_up_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFollowUpTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("jv_pc")) {
      Object obj = map.get("jv_pc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJvPc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("jv_code")) {
      Object obj = map.get("jv_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJvCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("store_code")) {
      Object obj = map.get("store_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rms_code")) {
      Object obj = map.get("rms_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRmsCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("list_import_user")) {
      Object obj = map.get("list_import_user");
      if(obj != null) {
        if(obj instanceof String) {
          this.setListImportUser((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("list_import_time")) {
      Object obj = map.get("list_import_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setListImportTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("market")) {
      Object obj = map.get("market");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMarket((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("area")) {
      Object obj = map.get("area");
      if(obj != null) {
        if(obj instanceof String) {
          this.setArea((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("un_certified_reason")) {
      Object obj = map.get("un_certified_reason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnCertifiedReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("un_certified_remark")) {
      Object obj = map.get("un_certified_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnCertifiedRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("risk_invoice_category")) {
      Object obj = map.get("risk_invoice_category");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRiskInvoiceCategory((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("origin_biz_order_no")) {
      Object obj = map.get("origin_biz_order_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginBizOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_repeat")) {
      Object obj = map.get("is_repeat");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsRepeat((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_need_auth")) {
      Object obj = map.get("is_need_auth");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsNeedAuth((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_send_exception")) {
      Object obj = map.get("is_send_exception");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsSendException((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("send_exception_remark")) {
      Object obj = map.get("send_exception_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSendExceptionRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auth_cancel_time")) {
      Object obj = map.get("auth_cancel_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthCancelTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("organization_code")) {
      Object obj = map.get("organization_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrganizationCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vehicle_type")) {
      Object obj = map.get("vehicle_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVehicleType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vehicle_brand")) {
      Object obj = map.get("vehicle_brand");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVehicleBrand((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("production_area")) {
      Object obj = map.get("production_area");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductionArea((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cert_no")) {
      Object obj = map.get("cert_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCertNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("inspection_no")) {
      Object obj = map.get("inspection_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInspectionNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("engine_no")) {
      Object obj = map.get("engine_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEngineNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vehicle_no")) {
      Object obj = map.get("vehicle_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVehicleNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tonnage")) {
      Object obj = map.get("tonnage");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTonnage((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("max_capacity")) {
      Object obj = map.get("max_capacity");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMaxCapacity((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("import_cert_no")) {
      Object obj = map.get("import_cert_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setImportCertNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_auth_name")) {
      Object obj = map.get("tax_auth_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxAuthName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_auth_code")) {
      Object obj = map.get("tax_auth_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxAuthCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_paid_proof")) {
      Object obj = map.get("tax_paid_proof");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxPaidProof((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_tax_cancel_auth")) {
      Object obj = map.get("is_tax_cancel_auth");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsTaxCancelAuth((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_cancel_auth_time")) {
      Object obj = map.get("tax_cancel_auth_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxCancelAuthTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("actual_auth_way")) {
      Object obj = map.get("actual_auth_way");
      if(obj != null) {
        if(obj instanceof String) {
          this.setActualAuthWay((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_sync_time")) {
      Object obj = map.get("seller_sync_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerSyncTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("last_modify_time")) {
      Object obj = map.get("last_modify_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLastModifyTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_no")) {
      Object obj = map.get("seller_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_company_id")) {
      Object obj = map.get("seller_company_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerCompanyId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("data_sharding")) {
      Object obj = map.get("data_sharding");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDataSharding((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("back_express_number")) {
      Object obj = map.get("back_express_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBackExpressNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("el_flag")) {
      Object obj = map.get("el_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setElFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_ledger_not_arrive")) {
      Object obj = map.get("is_ledger_not_arrive");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsLedgerNotArrive((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auth_show_category")) {
      Object obj = map.get("auth_show_category");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthShowCategory((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("biz_order_id")) {
      Object obj = map.get("biz_order_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizOrderId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("outer_invoice_id")) {
      Object obj = map.get("outer_invoice_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOuterInvoiceId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_issued_status")) {
      Object obj = map.get("seller_issued_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerIssuedStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_rate_definition")) {
      Object obj = map.get("tax_rate_definition");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxRateDefinition((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_tenant_id")) {
      Object obj = map.get("seller_tenant_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTenantId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customer_no")) {
      Object obj = map.get("customer_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("recog_way")) {
      Object obj = map.get("recog_way");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecogWay((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("business_tag")) {
      Object obj = map.get("business_tag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessTag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("risk_status")) {
      Object obj = map.get("risk_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRiskStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("transfer_status")) {
      Object obj = map.get("transfer_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTransferStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sense_word")) {
      Object obj = map.get("sense_word");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSenseWord((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sense_word_level")) {
      Object obj = map.get("sense_word_level");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSenseWordLevel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pur_company_exception_content")) {
      Object obj = map.get("pur_company_exception_content");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurCompanyExceptionContent((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("custom_remark")) {
      Object obj = map.get("custom_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("origin_file_type")) {
      Object obj = map.get("origin_file_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginFileType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payment_time")) {
      Object obj = map.get("payment_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("section_name")) {
      Object obj = map.get("section_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSectionName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auth_task_id")) {
      Object obj = map.get("auth_task_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthTaskId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auth_tax_error_code")) {
      Object obj = map.get("auth_tax_error_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthTaxErrorCode((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("invoiceViewAndInvoiceMainRelation.id")) {
        Object obj = map.get("invoiceViewAndInvoiceMainRelation.id");
        if(obj instanceof Long) {
          this.setInvoiceViewAndInvoiceMainRelationId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceViewAndInvoiceMainRelationId(Long.parseLong((String)obj));
        }
      }
      if(map.containsKey("invoiceViewAndInvoiceVerifyRelation.id")) {
        Object obj = map.get("invoiceViewAndInvoiceVerifyRelation.id");
        if(obj instanceof Long) {
          this.setInvoiceViewAndInvoiceVerifyRelationId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceViewAndInvoiceVerifyRelationId(Long.parseLong((String)obj));
        }
      }
      if(map.containsKey("invoiceViewAndInvoiceAuthRelation.id")) {
        Object obj = map.get("invoiceViewAndInvoiceAuthRelation.id");
        if(obj instanceof Long) {
          this.setInvoiceViewAndInvoiceAuthRelationId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceViewAndInvoiceAuthRelationId(Long.parseLong((String)obj));
        }
      }
      if(map.containsKey("invoiceViewAndInvoiceBusinessRelation.id")) {
        Object obj = map.get("invoiceViewAndInvoiceBusinessRelation.id");
        if(obj instanceof Long) {
          this.setInvoiceViewAndInvoiceBusinessRelationId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceViewAndInvoiceBusinessRelationId(Long.parseLong((String)obj));
        }
      }
      if(map.containsKey("companyAndInvoiceViewRelation.id")) {
        Object obj = map.get("companyAndInvoiceViewRelation.id");
        if(obj instanceof Long) {
          this.setCompanyAndInvoiceViewRelationId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCompanyAndInvoiceViewRelationId(Long.parseLong((String)obj));
        }
      }
  }
}
