package com.xforceplus.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ext4
 * </p>
 *
 * @author ultraman
 * @since 2025-11-03
 */
public enum Ext4 {

    _1("1", "进货发票"),
    _2("2", "退货发票"),
    _3("3", "返利发票"),
    _4("4", "转税率发票"),
    _5("5", "调账发票"),
    _6("6", "进口类发票"),
    _7("7", "虚拟发票"),
    _8("8", "物流退款发票"),
    _9("9", "转仓发票"),
    _10("10", "费用发票"),
    _11("11", "退货-转税率发票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    Ext4(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Ext4 fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            case "10":
                return _10;
            case "11":
                return _11;
            default:
                return null;
        }
    }
}
