package com.xforceplus.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserinvoicemanagesaas.entity.CustomsPaymentItem;
import com.xforceplus.purchaserinvoicemanagesaas.service.ICustomsPaymentItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 海关缴款书明细对象前端控制器
 *
 * @author ultraman
 * @date 2024-10-29
 */
@RestController
public class CustomsPaymentItemController {

  @Autowired
  private ICustomsPaymentItemService customsPaymentItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param customsPaymentItem 海关缴款书明细对象
   * @return
   */
  @GetMapping("/customspaymentitems" )
  public XfR getCustomsPaymentItems(XfPage page, CustomsPaymentItem customsPaymentItem) {
    return XfR.ok(customsPaymentItemServiceImpl.page(page, Wrappers.query(customsPaymentItem)));
  }

  /**
   * 通过id查询海关缴款书明细对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/customspaymentitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(customsPaymentItemServiceImpl.getById(id));
  }

  /**
   * 新增海关缴款书明细对象
   * @param customsPaymentItem 海关缴款书明细对象
   * @return XfR
   */
  @PostMapping("/customspaymentitems")
  public XfR save(@RequestBody CustomsPaymentItem customsPaymentItem) {
     return XfR.ok(customsPaymentItemServiceImpl.save(customsPaymentItem));
  }

  /**
   * 修改-传入修改后的全部数据海关缴款书明细对象
   * @param customsPaymentItem 海关缴款书明细对象
   * @return XfR
   */
  @PutMapping("/customspaymentitems/{id}")
  public XfR putUpdate(@RequestBody CustomsPaymentItem customsPaymentItem,@PathVariable Long id) {
      customsPaymentItem.setId(id);
      return XfR.ok(customsPaymentItemServiceImpl.updateById(customsPaymentItem));
  }

  /**
   * 修改-传入修改的数据海关缴款书明细对象
   * @param customsPaymentItem 海关缴款书明细对象
   * @return XfR
   */
  @PatchMapping("/customspaymentitems/{id}")
  public XfR patchUpdate(@RequestBody CustomsPaymentItem customsPaymentItem,@PathVariable Long id) {
      CustomsPaymentItem upcustomsPaymentItem = customsPaymentItemServiceImpl.getById(id);
      if(upcustomsPaymentItem != null){
        upcustomsPaymentItem = ObjectCopyUtils.copyProperties(customsPaymentItem,upcustomsPaymentItem,true);
      }
      return XfR.ok(customsPaymentItemServiceImpl.updateById(upcustomsPaymentItem));
  }

  /**
   * 通过id删除海关缴款书明细对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/customspaymentitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(customsPaymentItemServiceImpl.removeById(id));
  }

  @PostMapping("/customspaymentitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "customs_payment_item");
     params.put("request", condition);

     return XfR.ok(customsPaymentItemServiceImpl.querys(params));
  }

}
