package com.xforceplus.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserinvoicemanagesaas.entity.InvoiceMainDto;
import com.xforceplus.purchaserinvoicemanagesaas.service.IInvoiceMainDtoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 前端视图专用前端控制器
 *
 * @author ultraman
 * @date 2024-10-29
 */
@RestController
public class InvoiceMainDtoController {

  @Autowired
  private IInvoiceMainDtoService invoiceMainDtoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceMainDto 前端视图专用
   * @return
   */
  @GetMapping("/invoicemaindtos" )
  public XfR getInvoiceMainDtos(XfPage page, InvoiceMainDto invoiceMainDto) {
    return XfR.ok(invoiceMainDtoServiceImpl.page(page, Wrappers.query(invoiceMainDto)));
  }

  /**
   * 通过id查询前端视图专用
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicemaindtos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceMainDtoServiceImpl.getById(id));
  }

  /**
   * 新增前端视图专用
   * @param invoiceMainDto 前端视图专用
   * @return XfR
   */
  @PostMapping("/invoicemaindtos")
  public XfR save(@RequestBody InvoiceMainDto invoiceMainDto) {
     return XfR.ok(invoiceMainDtoServiceImpl.save(invoiceMainDto));
  }

  /**
   * 修改-传入修改后的全部数据前端视图专用
   * @param invoiceMainDto 前端视图专用
   * @return XfR
   */
  @PutMapping("/invoicemaindtos/{id}")
  public XfR putUpdate(@RequestBody InvoiceMainDto invoiceMainDto,@PathVariable Long id) {
      invoiceMainDto.setId(id);
      return XfR.ok(invoiceMainDtoServiceImpl.updateById(invoiceMainDto));
  }

  /**
   * 修改-传入修改的数据前端视图专用
   * @param invoiceMainDto 前端视图专用
   * @return XfR
   */
  @PatchMapping("/invoicemaindtos/{id}")
  public XfR patchUpdate(@RequestBody InvoiceMainDto invoiceMainDto,@PathVariable Long id) {
      InvoiceMainDto upinvoiceMainDto = invoiceMainDtoServiceImpl.getById(id);
      if(upinvoiceMainDto != null){
        upinvoiceMainDto = ObjectCopyUtils.copyProperties(invoiceMainDto,upinvoiceMainDto,true);
      }
      return XfR.ok(invoiceMainDtoServiceImpl.updateById(upinvoiceMainDto));
  }

  /**
   * 通过id删除前端视图专用
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicemaindtos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceMainDtoServiceImpl.removeById(id));
  }

  @PostMapping("/invoicemaindtos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_main_dto");
     params.put("request", condition);

     return XfR.ok(invoiceMainDtoServiceImpl.querys(params));
  }

}
