package com.xforceplus.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserinvoicemanagesaas.entity.InvoiceNoComplianceLog;
import com.xforceplus.purchaserinvoicemanagesaas.service.IInvoiceNoComplianceLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 发票不合规履历前端控制器
 *
 * @author ultraman
 * @date 2025-09-23
 */
@RestController
public class InvoiceNoComplianceLogController {

  @Autowired
  private IInvoiceNoComplianceLogService invoiceNoComplianceLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceNoComplianceLog 发票不合规履历
   * @return
   */
  @GetMapping("/invoicenocompliancelogs" )
  public XfR getInvoiceNoComplianceLogs(XfPage page, InvoiceNoComplianceLog invoiceNoComplianceLog) {
    return XfR.ok(invoiceNoComplianceLogServiceImpl.page(page, Wrappers.query(invoiceNoComplianceLog)));
  }

  /**
   * 通过id查询发票不合规履历
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicenocompliancelogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceNoComplianceLogServiceImpl.getById(id));
  }

  /**
   * 新增发票不合规履历
   * @param invoiceNoComplianceLog 发票不合规履历
   * @return XfR
   */
  @PostMapping("/invoicenocompliancelogs")
  public XfR save(@RequestBody InvoiceNoComplianceLog invoiceNoComplianceLog) {
     return XfR.ok(invoiceNoComplianceLogServiceImpl.save(invoiceNoComplianceLog));
  }

  /**
   * 修改-传入修改后的全部数据发票不合规履历
   * @param invoiceNoComplianceLog 发票不合规履历
   * @return XfR
   */
  @PutMapping("/invoicenocompliancelogs/{id}")
  public XfR putUpdate(@RequestBody InvoiceNoComplianceLog invoiceNoComplianceLog,@PathVariable Long id) {
      invoiceNoComplianceLog.setId(id);
      return XfR.ok(invoiceNoComplianceLogServiceImpl.updateById(invoiceNoComplianceLog));
  }

  /**
   * 修改-传入修改的数据发票不合规履历
   * @param invoiceNoComplianceLog 发票不合规履历
   * @return XfR
   */
  @PatchMapping("/invoicenocompliancelogs/{id}")
  public XfR patchUpdate(@RequestBody InvoiceNoComplianceLog invoiceNoComplianceLog,@PathVariable Long id) {
      InvoiceNoComplianceLog upinvoiceNoComplianceLog = invoiceNoComplianceLogServiceImpl.getById(id);
      if(upinvoiceNoComplianceLog != null){
        upinvoiceNoComplianceLog = ObjectCopyUtils.copyProperties(invoiceNoComplianceLog,upinvoiceNoComplianceLog,true);
      }
      return XfR.ok(invoiceNoComplianceLogServiceImpl.updateById(upinvoiceNoComplianceLog));
  }

  /**
   * 通过id删除发票不合规履历
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicenocompliancelogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceNoComplianceLogServiceImpl.removeById(id));
  }

  @PostMapping("/invoicenocompliancelogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_no_compliance_log");
     params.put("request", condition);

     return XfR.ok(invoiceNoComplianceLogServiceImpl.querys(params));
  }

}
