package com.xforceplus.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserinvoicemanagesaas.entity.TenantFunctionConfig;
import com.xforceplus.purchaserinvoicemanagesaas.service.ITenantFunctionConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 租户功能配置对象前端控制器
 *
 * @author ultraman
 * @date 2025-09-23
 */
@RestController
public class TenantFunctionConfigController {

  @Autowired
  private ITenantFunctionConfigService tenantFunctionConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param tenantFunctionConfig 租户功能配置对象
   * @return
   */
  @GetMapping("/tenantfunctionconfigs" )
  public XfR getTenantFunctionConfigs(XfPage page, TenantFunctionConfig tenantFunctionConfig) {
    return XfR.ok(tenantFunctionConfigServiceImpl.page(page, Wrappers.query(tenantFunctionConfig)));
  }

  /**
   * 通过id查询租户功能配置对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/tenantfunctionconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(tenantFunctionConfigServiceImpl.getById(id));
  }

  /**
   * 新增租户功能配置对象
   * @param tenantFunctionConfig 租户功能配置对象
   * @return XfR
   */
  @PostMapping("/tenantfunctionconfigs")
  public XfR save(@RequestBody TenantFunctionConfig tenantFunctionConfig) {
     return XfR.ok(tenantFunctionConfigServiceImpl.save(tenantFunctionConfig));
  }

  /**
   * 修改-传入修改后的全部数据租户功能配置对象
   * @param tenantFunctionConfig 租户功能配置对象
   * @return XfR
   */
  @PutMapping("/tenantfunctionconfigs/{id}")
  public XfR putUpdate(@RequestBody TenantFunctionConfig tenantFunctionConfig,@PathVariable Long id) {
      tenantFunctionConfig.setId(id);
      return XfR.ok(tenantFunctionConfigServiceImpl.updateById(tenantFunctionConfig));
  }

  /**
   * 修改-传入修改的数据租户功能配置对象
   * @param tenantFunctionConfig 租户功能配置对象
   * @return XfR
   */
  @PatchMapping("/tenantfunctionconfigs/{id}")
  public XfR patchUpdate(@RequestBody TenantFunctionConfig tenantFunctionConfig,@PathVariable Long id) {
      TenantFunctionConfig uptenantFunctionConfig = tenantFunctionConfigServiceImpl.getById(id);
      if(uptenantFunctionConfig != null){
        uptenantFunctionConfig = ObjectCopyUtils.copyProperties(tenantFunctionConfig,uptenantFunctionConfig,true);
      }
      return XfR.ok(tenantFunctionConfigServiceImpl.updateById(uptenantFunctionConfig));
  }

  /**
   * 通过id删除租户功能配置对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/tenantfunctionconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(tenantFunctionConfigServiceImpl.removeById(id));
  }

  @PostMapping("/tenantfunctionconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tenant_function_config");
     params.put("request", condition);

     return XfR.ok(tenantFunctionConfigServiceImpl.querys(params));
  }

}
