package com.xforceplus.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserinvoicemanagesaas.entity.WithholdingVoucher;
import com.xforceplus.purchaserinvoicemanagesaas.service.IWithholdingVoucherService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-09-23
 */
@RestController
public class WithholdingVoucherController {

  @Autowired
  private IWithholdingVoucherService withholdingVoucherServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param withholdingVoucher ${table.comment}
   * @return
   */
  @GetMapping("/withholdingvouchers" )
  public XfR getWithholdingVouchers(XfPage page, WithholdingVoucher withholdingVoucher) {
    return XfR.ok(withholdingVoucherServiceImpl.page(page, Wrappers.query(withholdingVoucher)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/withholdingvouchers/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(withholdingVoucherServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param withholdingVoucher ${table.comment}
   * @return XfR
   */
  @PostMapping("/withholdingvouchers")
  public XfR save(@RequestBody WithholdingVoucher withholdingVoucher) {
     return XfR.ok(withholdingVoucherServiceImpl.save(withholdingVoucher));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param withholdingVoucher ${table.comment}
   * @return XfR
   */
  @PutMapping("/withholdingvouchers/{id}")
  public XfR putUpdate(@RequestBody WithholdingVoucher withholdingVoucher,@PathVariable Long id) {
      withholdingVoucher.setId(id);
      return XfR.ok(withholdingVoucherServiceImpl.updateById(withholdingVoucher));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param withholdingVoucher ${table.comment}
   * @return XfR
   */
  @PatchMapping("/withholdingvouchers/{id}")
  public XfR patchUpdate(@RequestBody WithholdingVoucher withholdingVoucher,@PathVariable Long id) {
      WithholdingVoucher upwithholdingVoucher = withholdingVoucherServiceImpl.getById(id);
      if(upwithholdingVoucher != null){
        upwithholdingVoucher = ObjectCopyUtils.copyProperties(withholdingVoucher,upwithholdingVoucher,true);
      }
      return XfR.ok(withholdingVoucherServiceImpl.updateById(upwithholdingVoucher));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/withholdingvouchers/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(withholdingVoucherServiceImpl.removeById(id));
  }

  @PostMapping("/withholdingvouchers/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "withholding_voucher");
     params.put("request", condition);

     return XfR.ok(withholdingVoucherServiceImpl.querys(params));
  }

}
