package com.xforceplus.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserinvoicemanagesaas.entity.InvoiceBuildingService;
import com.xforceplus.purchaserinvoicemanagesaas.service.IInvoiceBuildingServiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 发票建筑服务对象前端控制器
 *
 * @author ultraman
 * @date 2025-10-23
 */
@RestController
public class InvoiceBuildingServiceController {

  @Autowired
  private IInvoiceBuildingServiceService invoiceBuildingServiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceBuildingService 发票建筑服务对象
   * @return
   */
  @GetMapping("/invoicebuildingservices" )
  public XfR getInvoiceBuildingServices(XfPage page, InvoiceBuildingService invoiceBuildingService) {
    return XfR.ok(invoiceBuildingServiceServiceImpl.page(page, Wrappers.query(invoiceBuildingService)));
  }

  /**
   * 通过id查询发票建筑服务对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicebuildingservices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceBuildingServiceServiceImpl.getById(id));
  }

  /**
   * 新增发票建筑服务对象
   * @param invoiceBuildingService 发票建筑服务对象
   * @return XfR
   */
  @PostMapping("/invoicebuildingservices")
  public XfR save(@RequestBody InvoiceBuildingService invoiceBuildingService) {
     return XfR.ok(invoiceBuildingServiceServiceImpl.save(invoiceBuildingService));
  }

  /**
   * 修改-传入修改后的全部数据发票建筑服务对象
   * @param invoiceBuildingService 发票建筑服务对象
   * @return XfR
   */
  @PutMapping("/invoicebuildingservices/{id}")
  public XfR putUpdate(@RequestBody InvoiceBuildingService invoiceBuildingService,@PathVariable Long id) {
      invoiceBuildingService.setId(id);
      return XfR.ok(invoiceBuildingServiceServiceImpl.updateById(invoiceBuildingService));
  }

  /**
   * 修改-传入修改的数据发票建筑服务对象
   * @param invoiceBuildingService 发票建筑服务对象
   * @return XfR
   */
  @PatchMapping("/invoicebuildingservices/{id}")
  public XfR patchUpdate(@RequestBody InvoiceBuildingService invoiceBuildingService,@PathVariable Long id) {
      InvoiceBuildingService upinvoiceBuildingService = invoiceBuildingServiceServiceImpl.getById(id);
      if(upinvoiceBuildingService != null){
        upinvoiceBuildingService = ObjectCopyUtils.copyProperties(invoiceBuildingService,upinvoiceBuildingService,true);
      }
      return XfR.ok(invoiceBuildingServiceServiceImpl.updateById(upinvoiceBuildingService));
  }

  /**
   * 通过id删除发票建筑服务对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicebuildingservices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceBuildingServiceServiceImpl.removeById(id));
  }

  @PostMapping("/invoicebuildingservices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_building_service");
     params.put("request", condition);

     return XfR.ok(invoiceBuildingServiceServiceImpl.querys(params));
  }

}
