package com.xforceplus.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserinvoicemanagesaas.entity.InvoiceRealEstateLease;
import com.xforceplus.purchaserinvoicemanagesaas.service.IInvoiceRealEstateLeaseService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 发票不动产租赁对象前端控制器
 *
 * @author ultraman
 * @date 2025-10-23
 */
@RestController
public class InvoiceRealEstateLeaseController {

  @Autowired
  private IInvoiceRealEstateLeaseService invoiceRealEstateLeaseServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceRealEstateLease 发票不动产租赁对象
   * @return
   */
  @GetMapping("/invoicerealestateleases" )
  public XfR getInvoiceRealEstateLeases(XfPage page, InvoiceRealEstateLease invoiceRealEstateLease) {
    return XfR.ok(invoiceRealEstateLeaseServiceImpl.page(page, Wrappers.query(invoiceRealEstateLease)));
  }

  /**
   * 通过id查询发票不动产租赁对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicerealestateleases/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceRealEstateLeaseServiceImpl.getById(id));
  }

  /**
   * 新增发票不动产租赁对象
   * @param invoiceRealEstateLease 发票不动产租赁对象
   * @return XfR
   */
  @PostMapping("/invoicerealestateleases")
  public XfR save(@RequestBody InvoiceRealEstateLease invoiceRealEstateLease) {
     return XfR.ok(invoiceRealEstateLeaseServiceImpl.save(invoiceRealEstateLease));
  }

  /**
   * 修改-传入修改后的全部数据发票不动产租赁对象
   * @param invoiceRealEstateLease 发票不动产租赁对象
   * @return XfR
   */
  @PutMapping("/invoicerealestateleases/{id}")
  public XfR putUpdate(@RequestBody InvoiceRealEstateLease invoiceRealEstateLease,@PathVariable Long id) {
      invoiceRealEstateLease.setId(id);
      return XfR.ok(invoiceRealEstateLeaseServiceImpl.updateById(invoiceRealEstateLease));
  }

  /**
   * 修改-传入修改的数据发票不动产租赁对象
   * @param invoiceRealEstateLease 发票不动产租赁对象
   * @return XfR
   */
  @PatchMapping("/invoicerealestateleases/{id}")
  public XfR patchUpdate(@RequestBody InvoiceRealEstateLease invoiceRealEstateLease,@PathVariable Long id) {
      InvoiceRealEstateLease upinvoiceRealEstateLease = invoiceRealEstateLeaseServiceImpl.getById(id);
      if(upinvoiceRealEstateLease != null){
        upinvoiceRealEstateLease = ObjectCopyUtils.copyProperties(invoiceRealEstateLease,upinvoiceRealEstateLease,true);
      }
      return XfR.ok(invoiceRealEstateLeaseServiceImpl.updateById(upinvoiceRealEstateLease));
  }

  /**
   * 通过id删除发票不动产租赁对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicerealestateleases/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceRealEstateLeaseServiceImpl.removeById(id));
  }

  @PostMapping("/invoicerealestateleases/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_real_estate_lease");
     params.put("request", condition);

     return XfR.ok(invoiceRealEstateLeaseServiceImpl.querys(params));
  }

}
