package com.xforceplus.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserinvoicemanagesaas.entity.InvoiceVehicleAndVesselTax;
import com.xforceplus.purchaserinvoicemanagesaas.service.IInvoiceVehicleAndVesselTaxService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 发票代征车船税对象前端控制器
 *
 * @author ultraman
 * @date 2025-10-23
 */
@RestController
public class InvoiceVehicleAndVesselTaxController {

  @Autowired
  private IInvoiceVehicleAndVesselTaxService invoiceVehicleAndVesselTaxServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceVehicleAndVesselTax 发票代征车船税对象
   * @return
   */
  @GetMapping("/invoicevehicleandvesseltaxs" )
  public XfR getInvoiceVehicleAndVesselTaxs(XfPage page, InvoiceVehicleAndVesselTax invoiceVehicleAndVesselTax) {
    return XfR.ok(invoiceVehicleAndVesselTaxServiceImpl.page(page, Wrappers.query(invoiceVehicleAndVesselTax)));
  }

  /**
   * 通过id查询发票代征车船税对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicevehicleandvesseltaxs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceVehicleAndVesselTaxServiceImpl.getById(id));
  }

  /**
   * 新增发票代征车船税对象
   * @param invoiceVehicleAndVesselTax 发票代征车船税对象
   * @return XfR
   */
  @PostMapping("/invoicevehicleandvesseltaxs")
  public XfR save(@RequestBody InvoiceVehicleAndVesselTax invoiceVehicleAndVesselTax) {
     return XfR.ok(invoiceVehicleAndVesselTaxServiceImpl.save(invoiceVehicleAndVesselTax));
  }

  /**
   * 修改-传入修改后的全部数据发票代征车船税对象
   * @param invoiceVehicleAndVesselTax 发票代征车船税对象
   * @return XfR
   */
  @PutMapping("/invoicevehicleandvesseltaxs/{id}")
  public XfR putUpdate(@RequestBody InvoiceVehicleAndVesselTax invoiceVehicleAndVesselTax,@PathVariable Long id) {
      invoiceVehicleAndVesselTax.setId(id);
      return XfR.ok(invoiceVehicleAndVesselTaxServiceImpl.updateById(invoiceVehicleAndVesselTax));
  }

  /**
   * 修改-传入修改的数据发票代征车船税对象
   * @param invoiceVehicleAndVesselTax 发票代征车船税对象
   * @return XfR
   */
  @PatchMapping("/invoicevehicleandvesseltaxs/{id}")
  public XfR patchUpdate(@RequestBody InvoiceVehicleAndVesselTax invoiceVehicleAndVesselTax,@PathVariable Long id) {
      InvoiceVehicleAndVesselTax upinvoiceVehicleAndVesselTax = invoiceVehicleAndVesselTaxServiceImpl.getById(id);
      if(upinvoiceVehicleAndVesselTax != null){
        upinvoiceVehicleAndVesselTax = ObjectCopyUtils.copyProperties(invoiceVehicleAndVesselTax,upinvoiceVehicleAndVesselTax,true);
      }
      return XfR.ok(invoiceVehicleAndVesselTaxServiceImpl.updateById(upinvoiceVehicleAndVesselTax));
  }

  /**
   * 通过id删除发票代征车船税对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicevehicleandvesseltaxs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceVehicleAndVesselTaxServiceImpl.removeById(id));
  }

  @PostMapping("/invoicevehicleandvesseltaxs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_vehicle_and_vessel_tax");
     params.put("request", condition);

     return XfR.ok(invoiceVehicleAndVesselTaxServiceImpl.querys(params));
  }

}
