package com.xforceplus.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserinvoicemanagesaas.entity.MatchBatchSend;
import com.xforceplus.purchaserinvoicemanagesaas.service.IMatchBatchSendService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 配单下发模块前端控制器
 *
 * @author ultraman
 * @date 2025-10-23
 */
@RestController
public class MatchBatchSendController {

  @Autowired
  private IMatchBatchSendService matchBatchSendServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param matchBatchSend 配单下发模块
   * @return
   */
  @GetMapping("/matchbatchsends" )
  public XfR getMatchBatchSends(XfPage page, MatchBatchSend matchBatchSend) {
    return XfR.ok(matchBatchSendServiceImpl.page(page, Wrappers.query(matchBatchSend)));
  }

  /**
   * 通过id查询配单下发模块
   * @param  id
   * @return XfR
   */
  @GetMapping("/matchbatchsends/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(matchBatchSendServiceImpl.getById(id));
  }

  /**
   * 新增配单下发模块
   * @param matchBatchSend 配单下发模块
   * @return XfR
   */
  @PostMapping("/matchbatchsends")
  public XfR save(@RequestBody MatchBatchSend matchBatchSend) {
     return XfR.ok(matchBatchSendServiceImpl.save(matchBatchSend));
  }

  /**
   * 修改-传入修改后的全部数据配单下发模块
   * @param matchBatchSend 配单下发模块
   * @return XfR
   */
  @PutMapping("/matchbatchsends/{id}")
  public XfR putUpdate(@RequestBody MatchBatchSend matchBatchSend,@PathVariable Long id) {
      matchBatchSend.setId(id);
      return XfR.ok(matchBatchSendServiceImpl.updateById(matchBatchSend));
  }

  /**
   * 修改-传入修改的数据配单下发模块
   * @param matchBatchSend 配单下发模块
   * @return XfR
   */
  @PatchMapping("/matchbatchsends/{id}")
  public XfR patchUpdate(@RequestBody MatchBatchSend matchBatchSend,@PathVariable Long id) {
      MatchBatchSend upmatchBatchSend = matchBatchSendServiceImpl.getById(id);
      if(upmatchBatchSend != null){
        upmatchBatchSend = ObjectCopyUtils.copyProperties(matchBatchSend,upmatchBatchSend,true);
      }
      return XfR.ok(matchBatchSendServiceImpl.updateById(upmatchBatchSend));
  }

  /**
   * 通过id删除配单下发模块
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/matchbatchsends/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(matchBatchSendServiceImpl.removeById(id));
  }

  @PostMapping("/matchbatchsends/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "match_batch_send");
     params.put("request", condition);

     return XfR.ok(matchBatchSendServiceImpl.querys(params));
  }

}
