package com.xforceplus.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserinvoicemanagesaas.entity.NcpInvoiceHandleTask;
import com.xforceplus.purchaserinvoicemanagesaas.service.INcpInvoiceHandleTaskService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 农产品发票处理任务对象前端控制器
 *
 * @author ultraman
 * @date 2025-10-23
 */
@RestController
public class NcpInvoiceHandleTaskController {

  @Autowired
  private INcpInvoiceHandleTaskService ncpInvoiceHandleTaskServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ncpInvoiceHandleTask 农产品发票处理任务对象
   * @return
   */
  @GetMapping("/ncpinvoicehandletasks" )
  public XfR getNcpInvoiceHandleTasks(XfPage page, NcpInvoiceHandleTask ncpInvoiceHandleTask) {
    return XfR.ok(ncpInvoiceHandleTaskServiceImpl.page(page, Wrappers.query(ncpInvoiceHandleTask)));
  }

  /**
   * 通过id查询农产品发票处理任务对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/ncpinvoicehandletasks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ncpInvoiceHandleTaskServiceImpl.getById(id));
  }

  /**
   * 新增农产品发票处理任务对象
   * @param ncpInvoiceHandleTask 农产品发票处理任务对象
   * @return XfR
   */
  @PostMapping("/ncpinvoicehandletasks")
  public XfR save(@RequestBody NcpInvoiceHandleTask ncpInvoiceHandleTask) {
     return XfR.ok(ncpInvoiceHandleTaskServiceImpl.save(ncpInvoiceHandleTask));
  }

  /**
   * 修改-传入修改后的全部数据农产品发票处理任务对象
   * @param ncpInvoiceHandleTask 农产品发票处理任务对象
   * @return XfR
   */
  @PutMapping("/ncpinvoicehandletasks/{id}")
  public XfR putUpdate(@RequestBody NcpInvoiceHandleTask ncpInvoiceHandleTask,@PathVariable Long id) {
      ncpInvoiceHandleTask.setId(id);
      return XfR.ok(ncpInvoiceHandleTaskServiceImpl.updateById(ncpInvoiceHandleTask));
  }

  /**
   * 修改-传入修改的数据农产品发票处理任务对象
   * @param ncpInvoiceHandleTask 农产品发票处理任务对象
   * @return XfR
   */
  @PatchMapping("/ncpinvoicehandletasks/{id}")
  public XfR patchUpdate(@RequestBody NcpInvoiceHandleTask ncpInvoiceHandleTask,@PathVariable Long id) {
      NcpInvoiceHandleTask upncpInvoiceHandleTask = ncpInvoiceHandleTaskServiceImpl.getById(id);
      if(upncpInvoiceHandleTask != null){
        upncpInvoiceHandleTask = ObjectCopyUtils.copyProperties(ncpInvoiceHandleTask,upncpInvoiceHandleTask,true);
      }
      return XfR.ok(ncpInvoiceHandleTaskServiceImpl.updateById(upncpInvoiceHandleTask));
  }

  /**
   * 通过id删除农产品发票处理任务对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ncpinvoicehandletasks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ncpInvoiceHandleTaskServiceImpl.removeById(id));
  }

  @PostMapping("/ncpinvoicehandletasks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ncp_invoice_handle_task");
     params.put("request", condition);

     return XfR.ok(ncpInvoiceHandleTaskServiceImpl.querys(params));
  }

}
