package com.xforceplus.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserinvoicemanagesaas.entity.TravelTicket;
import com.xforceplus.purchaserinvoicemanagesaas.service.ITravelTicketService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 行程单对象前端控制器
 *
 * @author ultraman
 * @date 2025-10-23
 */
@RestController
public class TravelTicketController {

  @Autowired
  private ITravelTicketService travelTicketServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param travelTicket 行程单对象
   * @return
   */
  @GetMapping("/traveltickets" )
  public XfR getTravelTickets(XfPage page, TravelTicket travelTicket) {
    return XfR.ok(travelTicketServiceImpl.page(page, Wrappers.query(travelTicket)));
  }

  /**
   * 通过id查询行程单对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/traveltickets/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(travelTicketServiceImpl.getById(id));
  }

  /**
   * 新增行程单对象
   * @param travelTicket 行程单对象
   * @return XfR
   */
  @PostMapping("/traveltickets")
  public XfR save(@RequestBody TravelTicket travelTicket) {
     return XfR.ok(travelTicketServiceImpl.save(travelTicket));
  }

  /**
   * 修改-传入修改后的全部数据行程单对象
   * @param travelTicket 行程单对象
   * @return XfR
   */
  @PutMapping("/traveltickets/{id}")
  public XfR putUpdate(@RequestBody TravelTicket travelTicket,@PathVariable Long id) {
      travelTicket.setId(id);
      return XfR.ok(travelTicketServiceImpl.updateById(travelTicket));
  }

  /**
   * 修改-传入修改的数据行程单对象
   * @param travelTicket 行程单对象
   * @return XfR
   */
  @PatchMapping("/traveltickets/{id}")
  public XfR patchUpdate(@RequestBody TravelTicket travelTicket,@PathVariable Long id) {
      TravelTicket uptravelTicket = travelTicketServiceImpl.getById(id);
      if(uptravelTicket != null){
        uptravelTicket = ObjectCopyUtils.copyProperties(travelTicket,uptravelTicket,true);
      }
      return XfR.ok(travelTicketServiceImpl.updateById(uptravelTicket));
  }

  /**
   * 通过id删除行程单对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/traveltickets/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(travelTicketServiceImpl.removeById(id));
  }

  @PostMapping("/traveltickets/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "travel_ticket");
     params.put("request", condition);

     return XfR.ok(travelTicketServiceImpl.querys(params));
  }

}
