package com.xforceplus.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserinvoicemanagesaas.entity.BizOrderDto;
import com.xforceplus.purchaserinvoicemanagesaas.service.IBizOrderDtoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 前端视图专用前端控制器
 *
 * @author ultraman
 * @date 2025-10-30
 */
@RestController
public class BizOrderDtoController {

  @Autowired
  private IBizOrderDtoService bizOrderDtoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bizOrderDto 前端视图专用
   * @return
   */
  @GetMapping("/bizorderdtos" )
  public XfR getBizOrderDtos(XfPage page, BizOrderDto bizOrderDto) {
    return XfR.ok(bizOrderDtoServiceImpl.page(page, Wrappers.query(bizOrderDto)));
  }

  /**
   * 通过id查询前端视图专用
   * @param  id
   * @return XfR
   */
  @GetMapping("/bizorderdtos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bizOrderDtoServiceImpl.getById(id));
  }

  /**
   * 新增前端视图专用
   * @param bizOrderDto 前端视图专用
   * @return XfR
   */
  @PostMapping("/bizorderdtos")
  public XfR save(@RequestBody BizOrderDto bizOrderDto) {
     return XfR.ok(bizOrderDtoServiceImpl.save(bizOrderDto));
  }

  /**
   * 修改-传入修改后的全部数据前端视图专用
   * @param bizOrderDto 前端视图专用
   * @return XfR
   */
  @PutMapping("/bizorderdtos/{id}")
  public XfR putUpdate(@RequestBody BizOrderDto bizOrderDto,@PathVariable Long id) {
      bizOrderDto.setId(id);
      return XfR.ok(bizOrderDtoServiceImpl.updateById(bizOrderDto));
  }

  /**
   * 修改-传入修改的数据前端视图专用
   * @param bizOrderDto 前端视图专用
   * @return XfR
   */
  @PatchMapping("/bizorderdtos/{id}")
  public XfR patchUpdate(@RequestBody BizOrderDto bizOrderDto,@PathVariable Long id) {
      BizOrderDto upbizOrderDto = bizOrderDtoServiceImpl.getById(id);
      if(upbizOrderDto != null){
        upbizOrderDto = ObjectCopyUtils.copyProperties(bizOrderDto,upbizOrderDto,true);
      }
      return XfR.ok(bizOrderDtoServiceImpl.updateById(upbizOrderDto));
  }

  /**
   * 通过id删除前端视图专用
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bizorderdtos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bizOrderDtoServiceImpl.removeById(id));
  }

  @PostMapping("/bizorderdtos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "biz_order_dto");
     params.put("request", condition);

     return XfR.ok(bizOrderDtoServiceImpl.querys(params));
  }

}
