package com.xforceplus.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserinvoicemanagesaas.entity.BizOrderInfo;
import com.xforceplus.purchaserinvoicemanagesaas.service.IBizOrderInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-30
 */
@RestController
public class BizOrderInfoController {

  @Autowired
  private IBizOrderInfoService bizOrderInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bizOrderInfo ${table.comment}
   * @return
   */
  @GetMapping("/bizorderinfos" )
  public XfR getBizOrderInfos(XfPage page, BizOrderInfo bizOrderInfo) {
    return XfR.ok(bizOrderInfoServiceImpl.page(page, Wrappers.query(bizOrderInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/bizorderinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bizOrderInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param bizOrderInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/bizorderinfos")
  public XfR save(@RequestBody BizOrderInfo bizOrderInfo) {
     return XfR.ok(bizOrderInfoServiceImpl.save(bizOrderInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param bizOrderInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/bizorderinfos/{id}")
  public XfR putUpdate(@RequestBody BizOrderInfo bizOrderInfo,@PathVariable Long id) {
      bizOrderInfo.setId(id);
      return XfR.ok(bizOrderInfoServiceImpl.updateById(bizOrderInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param bizOrderInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/bizorderinfos/{id}")
  public XfR patchUpdate(@RequestBody BizOrderInfo bizOrderInfo,@PathVariable Long id) {
      BizOrderInfo upbizOrderInfo = bizOrderInfoServiceImpl.getById(id);
      if(upbizOrderInfo != null){
        upbizOrderInfo = ObjectCopyUtils.copyProperties(bizOrderInfo,upbizOrderInfo,true);
      }
      return XfR.ok(bizOrderInfoServiceImpl.updateById(upbizOrderInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bizorderinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bizOrderInfoServiceImpl.removeById(id));
  }

  @PostMapping("/bizorderinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "biz_order_info");
     params.put("request", condition);

     return XfR.ok(bizOrderInfoServiceImpl.querys(params));
  }

}
