package com.xforceplus.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserinvoicemanagesaas.entity.InvoiceAuth;
import com.xforceplus.purchaserinvoicemanagesaas.service.IInvoiceAuthService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 认证相关信息前端控制器
 *
 * @author ultraman
 * @date 2025-10-30
 */
@RestController
public class InvoiceAuthController {

  @Autowired
  private IInvoiceAuthService invoiceAuthServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceAuth 认证相关信息
   * @return
   */
  @GetMapping("/invoiceauths" )
  public XfR getInvoiceAuths(XfPage page, InvoiceAuth invoiceAuth) {
    return XfR.ok(invoiceAuthServiceImpl.page(page, Wrappers.query(invoiceAuth)));
  }

  /**
   * 通过id查询认证相关信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoiceauths/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceAuthServiceImpl.getById(id));
  }

  /**
   * 新增认证相关信息
   * @param invoiceAuth 认证相关信息
   * @return XfR
   */
  @PostMapping("/invoiceauths")
  public XfR save(@RequestBody InvoiceAuth invoiceAuth) {
     return XfR.ok(invoiceAuthServiceImpl.save(invoiceAuth));
  }

  /**
   * 修改-传入修改后的全部数据认证相关信息
   * @param invoiceAuth 认证相关信息
   * @return XfR
   */
  @PutMapping("/invoiceauths/{id}")
  public XfR putUpdate(@RequestBody InvoiceAuth invoiceAuth,@PathVariable Long id) {
      invoiceAuth.setId(id);
      return XfR.ok(invoiceAuthServiceImpl.updateById(invoiceAuth));
  }

  /**
   * 修改-传入修改的数据认证相关信息
   * @param invoiceAuth 认证相关信息
   * @return XfR
   */
  @PatchMapping("/invoiceauths/{id}")
  public XfR patchUpdate(@RequestBody InvoiceAuth invoiceAuth,@PathVariable Long id) {
      InvoiceAuth upinvoiceAuth = invoiceAuthServiceImpl.getById(id);
      if(upinvoiceAuth != null){
        upinvoiceAuth = ObjectCopyUtils.copyProperties(invoiceAuth,upinvoiceAuth,true);
      }
      return XfR.ok(invoiceAuthServiceImpl.updateById(upinvoiceAuth));
  }

  /**
   * 通过id删除认证相关信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoiceauths/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceAuthServiceImpl.removeById(id));
  }

  @PostMapping("/invoiceauths/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_auth");
     params.put("request", condition);

     return XfR.ok(invoiceAuthServiceImpl.querys(params));
  }

}
