package com.xforceplus.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserinvoicemanagesaas.entity.InvoiceCheckTask;
import com.xforceplus.purchaserinvoicemanagesaas.service.IInvoiceCheckTaskService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 发票勾选记录对象前端控制器
 *
 * @author ultraman
 * @date 2025-10-30
 */
@RestController
public class InvoiceCheckTaskController {

  @Autowired
  private IInvoiceCheckTaskService invoiceCheckTaskServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceCheckTask 发票勾选记录对象
   * @return
   */
  @GetMapping("/invoicechecktasks" )
  public XfR getInvoiceCheckTasks(XfPage page, InvoiceCheckTask invoiceCheckTask) {
    return XfR.ok(invoiceCheckTaskServiceImpl.page(page, Wrappers.query(invoiceCheckTask)));
  }

  /**
   * 通过id查询发票勾选记录对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicechecktasks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceCheckTaskServiceImpl.getById(id));
  }

  /**
   * 新增发票勾选记录对象
   * @param invoiceCheckTask 发票勾选记录对象
   * @return XfR
   */
  @PostMapping("/invoicechecktasks")
  public XfR save(@RequestBody InvoiceCheckTask invoiceCheckTask) {
     return XfR.ok(invoiceCheckTaskServiceImpl.save(invoiceCheckTask));
  }

  /**
   * 修改-传入修改后的全部数据发票勾选记录对象
   * @param invoiceCheckTask 发票勾选记录对象
   * @return XfR
   */
  @PutMapping("/invoicechecktasks/{id}")
  public XfR putUpdate(@RequestBody InvoiceCheckTask invoiceCheckTask,@PathVariable Long id) {
      invoiceCheckTask.setId(id);
      return XfR.ok(invoiceCheckTaskServiceImpl.updateById(invoiceCheckTask));
  }

  /**
   * 修改-传入修改的数据发票勾选记录对象
   * @param invoiceCheckTask 发票勾选记录对象
   * @return XfR
   */
  @PatchMapping("/invoicechecktasks/{id}")
  public XfR patchUpdate(@RequestBody InvoiceCheckTask invoiceCheckTask,@PathVariable Long id) {
      InvoiceCheckTask upinvoiceCheckTask = invoiceCheckTaskServiceImpl.getById(id);
      if(upinvoiceCheckTask != null){
        upinvoiceCheckTask = ObjectCopyUtils.copyProperties(invoiceCheckTask,upinvoiceCheckTask,true);
      }
      return XfR.ok(invoiceCheckTaskServiceImpl.updateById(upinvoiceCheckTask));
  }

  /**
   * 通过id删除发票勾选记录对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicechecktasks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceCheckTaskServiceImpl.removeById(id));
  }

  @PostMapping("/invoicechecktasks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_check_task");
     params.put("request", condition);

     return XfR.ok(invoiceCheckTaskServiceImpl.querys(params));
  }

}
