package com.xforceplus.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserinvoicemanagesaas.entity.SellerCompanyInfo;
import com.xforceplus.purchaserinvoicemanagesaas.service.ISellerCompanyInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 销方公司信息前端控制器
 *
 * @author ultraman
 * @date 2025-10-30
 */
@RestController
public class SellerCompanyInfoController {

  @Autowired
  private ISellerCompanyInfoService sellerCompanyInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param sellerCompanyInfo 销方公司信息
   * @return
   */
  @GetMapping("/sellercompanyinfos" )
  public XfR getSellerCompanyInfos(XfPage page, SellerCompanyInfo sellerCompanyInfo) {
    return XfR.ok(sellerCompanyInfoServiceImpl.page(page, Wrappers.query(sellerCompanyInfo)));
  }

  /**
   * 通过id查询销方公司信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/sellercompanyinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(sellerCompanyInfoServiceImpl.getById(id));
  }

  /**
   * 新增销方公司信息
   * @param sellerCompanyInfo 销方公司信息
   * @return XfR
   */
  @PostMapping("/sellercompanyinfos")
  public XfR save(@RequestBody SellerCompanyInfo sellerCompanyInfo) {
     return XfR.ok(sellerCompanyInfoServiceImpl.save(sellerCompanyInfo));
  }

  /**
   * 修改-传入修改后的全部数据销方公司信息
   * @param sellerCompanyInfo 销方公司信息
   * @return XfR
   */
  @PutMapping("/sellercompanyinfos/{id}")
  public XfR putUpdate(@RequestBody SellerCompanyInfo sellerCompanyInfo,@PathVariable Long id) {
      sellerCompanyInfo.setId(id);
      return XfR.ok(sellerCompanyInfoServiceImpl.updateById(sellerCompanyInfo));
  }

  /**
   * 修改-传入修改的数据销方公司信息
   * @param sellerCompanyInfo 销方公司信息
   * @return XfR
   */
  @PatchMapping("/sellercompanyinfos/{id}")
  public XfR patchUpdate(@RequestBody SellerCompanyInfo sellerCompanyInfo,@PathVariable Long id) {
      SellerCompanyInfo upsellerCompanyInfo = sellerCompanyInfoServiceImpl.getById(id);
      if(upsellerCompanyInfo != null){
        upsellerCompanyInfo = ObjectCopyUtils.copyProperties(sellerCompanyInfo,upsellerCompanyInfo,true);
      }
      return XfR.ok(sellerCompanyInfoServiceImpl.updateById(upsellerCompanyInfo));
  }

  /**
   * 通过id删除销方公司信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/sellercompanyinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(sellerCompanyInfoServiceImpl.removeById(id));
  }

  @PostMapping("/sellercompanyinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "seller_company_info");
     params.put("request", condition);

     return XfR.ok(sellerCompanyInfoServiceImpl.querys(params));
  }

}
