package com.xforceplus.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserinvoicemanagesaas.entity.InvoiceOperateLog;
import com.xforceplus.purchaserinvoicemanagesaas.service.IInvoiceOperateLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 用户操作行为履历前端控制器
 *
 * @author ultraman
 * @date 2025-11-03
 */
@RestController
public class InvoiceOperateLogController {

  @Autowired
  private IInvoiceOperateLogService invoiceOperateLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceOperateLog 用户操作行为履历
   * @return
   */
  @GetMapping("/invoiceoperatelogs" )
  public XfR getInvoiceOperateLogs(XfPage page, InvoiceOperateLog invoiceOperateLog) {
    return XfR.ok(invoiceOperateLogServiceImpl.page(page, Wrappers.query(invoiceOperateLog)));
  }

  /**
   * 通过id查询用户操作行为履历
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoiceoperatelogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceOperateLogServiceImpl.getById(id));
  }

  /**
   * 新增用户操作行为履历
   * @param invoiceOperateLog 用户操作行为履历
   * @return XfR
   */
  @PostMapping("/invoiceoperatelogs")
  public XfR save(@RequestBody InvoiceOperateLog invoiceOperateLog) {
     return XfR.ok(invoiceOperateLogServiceImpl.save(invoiceOperateLog));
  }

  /**
   * 修改-传入修改后的全部数据用户操作行为履历
   * @param invoiceOperateLog 用户操作行为履历
   * @return XfR
   */
  @PutMapping("/invoiceoperatelogs/{id}")
  public XfR putUpdate(@RequestBody InvoiceOperateLog invoiceOperateLog,@PathVariable Long id) {
      invoiceOperateLog.setId(id);
      return XfR.ok(invoiceOperateLogServiceImpl.updateById(invoiceOperateLog));
  }

  /**
   * 修改-传入修改的数据用户操作行为履历
   * @param invoiceOperateLog 用户操作行为履历
   * @return XfR
   */
  @PatchMapping("/invoiceoperatelogs/{id}")
  public XfR patchUpdate(@RequestBody InvoiceOperateLog invoiceOperateLog,@PathVariable Long id) {
      InvoiceOperateLog upinvoiceOperateLog = invoiceOperateLogServiceImpl.getById(id);
      if(upinvoiceOperateLog != null){
        upinvoiceOperateLog = ObjectCopyUtils.copyProperties(invoiceOperateLog,upinvoiceOperateLog,true);
      }
      return XfR.ok(invoiceOperateLogServiceImpl.updateById(upinvoiceOperateLog));
  }

  /**
   * 通过id删除用户操作行为履历
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoiceoperatelogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceOperateLogServiceImpl.removeById(id));
  }

  @PostMapping("/invoiceoperatelogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_operate_log");
     params.put("request", condition);

     return XfR.ok(invoiceOperateLogServiceImpl.querys(params));
  }

}
