package com.xforceplus.purchaserinvoicemanagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserinvoicemanagesaas.entity.InvoiceTractorsAndCombines;
import com.xforceplus.purchaserinvoicemanagesaas.service.IInvoiceTractorsAndCombinesService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 发票拖拉机联合收割机对象前端控制器
 *
 * @author ultraman
 * @date 2025-11-03
 */
@RestController
public class InvoiceTractorsAndCombinesController {

  @Autowired
  private IInvoiceTractorsAndCombinesService invoiceTractorsAndCombinesServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceTractorsAndCombines 发票拖拉机联合收割机对象
   * @return
   */
  @GetMapping("/invoicetractorsandcombiness" )
  public XfR getInvoiceTractorsAndCombiness(XfPage page, InvoiceTractorsAndCombines invoiceTractorsAndCombines) {
    return XfR.ok(invoiceTractorsAndCombinesServiceImpl.page(page, Wrappers.query(invoiceTractorsAndCombines)));
  }

  /**
   * 通过id查询发票拖拉机联合收割机对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicetractorsandcombiness/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceTractorsAndCombinesServiceImpl.getById(id));
  }

  /**
   * 新增发票拖拉机联合收割机对象
   * @param invoiceTractorsAndCombines 发票拖拉机联合收割机对象
   * @return XfR
   */
  @PostMapping("/invoicetractorsandcombiness")
  public XfR save(@RequestBody InvoiceTractorsAndCombines invoiceTractorsAndCombines) {
     return XfR.ok(invoiceTractorsAndCombinesServiceImpl.save(invoiceTractorsAndCombines));
  }

  /**
   * 修改-传入修改后的全部数据发票拖拉机联合收割机对象
   * @param invoiceTractorsAndCombines 发票拖拉机联合收割机对象
   * @return XfR
   */
  @PutMapping("/invoicetractorsandcombiness/{id}")
  public XfR putUpdate(@RequestBody InvoiceTractorsAndCombines invoiceTractorsAndCombines,@PathVariable Long id) {
      invoiceTractorsAndCombines.setId(id);
      return XfR.ok(invoiceTractorsAndCombinesServiceImpl.updateById(invoiceTractorsAndCombines));
  }

  /**
   * 修改-传入修改的数据发票拖拉机联合收割机对象
   * @param invoiceTractorsAndCombines 发票拖拉机联合收割机对象
   * @return XfR
   */
  @PatchMapping("/invoicetractorsandcombiness/{id}")
  public XfR patchUpdate(@RequestBody InvoiceTractorsAndCombines invoiceTractorsAndCombines,@PathVariable Long id) {
      InvoiceTractorsAndCombines upinvoiceTractorsAndCombines = invoiceTractorsAndCombinesServiceImpl.getById(id);
      if(upinvoiceTractorsAndCombines != null){
        upinvoiceTractorsAndCombines = ObjectCopyUtils.copyProperties(invoiceTractorsAndCombines,upinvoiceTractorsAndCombines,true);
      }
      return XfR.ok(invoiceTractorsAndCombinesServiceImpl.updateById(upinvoiceTractorsAndCombines));
  }

  /**
   * 通过id删除发票拖拉机联合收割机对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicetractorsandcombiness/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceTractorsAndCombinesServiceImpl.removeById(id));
  }

  @PostMapping("/invoicetractorsandcombiness/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_tractors_and_combines");
     params.put("request", condition);

     return XfR.ok(invoiceTractorsAndCombinesServiceImpl.querys(params));
  }

}
