package com.xforceplus.purchaserinvoicesaas.controller;


/**
 * 机动车额外信息feign客户端
 *
 * @author ultraman
 * @date 2023-09-06
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserinvoicesaas.entity.InvoiceVehicle;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-invoice-saas")
public interface InvoiceVehicleFeignApi {

  /**
   * 通过id查询机动车额外信息
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceVehicle/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增机动车额外信息
   * @param invoiceVehicle 机动车额外信息
   * @return R
   */
  @PostMapping("/invoiceVehicle/add")
  public R save(@RequestBody InvoiceVehicle invoiceVehicle);

  /**
   * 修改机动车额外信息
   * @param invoiceVehicle 机动车额外信息
   * @return R
   */
  @PostMapping("/invoiceVehicle/update")
  public R updateById(@RequestBody InvoiceVehicle invoiceVehicle);

  /**
   * 通过id删除机动车额外信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceVehicle/del/{id}" )
  public R removeById(@PathVariable Long id);

}