package com.xforceplus.purchaserinvoicesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 认证方式
 * </p>
 *
 * @author ultraman
 * @since 2022-12-14
 */
public enum AuthStyle {

    _0("0", "无"),
    _10("10", "页面手工勾选"),
    _11("11", "外部接口勾选"),
    _12("12", "国税底账勾选"),
    _13("13", "系统自动勾选"),
    _14("14", "文件导入勾选");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AuthStyle(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AuthStyle fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            case "13":
                return _13;
            case "14":
                return _14;
            default:
                return null;
        }
    }
}
