package com.xforceplus.purchaserinvoicesaas.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 发票识别相关信息
 * </p>
 *
 * @author ultraman
 * @since 2022-12-14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceRecog implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 扫描id
   */
  private Long recogId;

  /**
   * 组织id
   */
  private Long orgId;

  /**
   * 识别状态
   */
  private String recogStatus;

  /**
   * 扫描人姓名
   */
  private String recogUserName;

  /**
   * 扫描人id
   */
  private Long recogUserId;

  /**
   * 扫描影像地址
   */
  private String recogUrl;

  /**
   * 扫描时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime recogTime;

  /**
   * 扫描联次
   */
  private String recogSheet;

  /**
   * 文件类型
   */
  private String fileType;

  /**
   * 数据状态
   */
  private String dataStatus;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 文件来源
   */
  private String fileOrigin;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("recog_id", recogId);
      map.put("org_id", orgId);
      map.put("recog_status", recogStatus);
      map.put("recog_user_name", recogUserName);
      map.put("recog_user_id", recogUserId);
      map.put("recog_url", recogUrl);
      map.put("recog_time", BocpGenUtils.toTimestamp(recogTime));
      map.put("recog_sheet", recogSheet);
      map.put("file_type", fileType);
      map.put("data_status", dataStatus);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("file_origin", fileOrigin);
      return map;
  }

  public static InvoiceRecog fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceRecog entity = new InvoiceRecog();
    if(map.containsKey("recog_id")) {
      Object obj = map.get("recog_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRecogId((Long)obj);
        } else if(obj instanceof String) {
          entity.setRecogId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRecogId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("recog_status")) {
      Object obj = map.get("recog_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRecogStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recog_user_name")) {
      Object obj = map.get("recog_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRecogUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recog_user_id")) {
      Object obj = map.get("recog_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRecogUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setRecogUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRecogUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("recog_url")) {
      Object obj = map.get("recog_url");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRecogUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recog_time")) {
      Object obj = map.get("recog_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRecogTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setRecogTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setRecogTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRecogTime(null);
      }
    }
    if(map.containsKey("recog_sheet")) {
      Object obj = map.get("recog_sheet");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRecogSheet((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_type")) {
      Object obj = map.get("file_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFileType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("data_status")) {
      Object obj = map.get("data_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDataStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_origin")) {
      Object obj = map.get("file_origin");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFileOrigin((String)obj);
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("recog_id")) {
      Object obj = map.get("recog_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRecogId((Long)obj);
        } else if(obj instanceof String) {
          this.setRecogId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setRecogId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrgId((Long)obj);
        } else if(obj instanceof String) {
          this.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrgId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("recog_status")) {
      Object obj = map.get("recog_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecogStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("recog_user_name")) {
      Object obj = map.get("recog_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecogUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("recog_user_id")) {
      Object obj = map.get("recog_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRecogUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setRecogUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setRecogUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("recog_url")) {
      Object obj = map.get("recog_url");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecogUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("recog_time")) {
      Object obj = map.get("recog_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRecogTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setRecogTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setRecogTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setRecogTime(null);
      }
    }
    if(map.containsKey("recog_sheet")) {
      Object obj = map.get("recog_sheet");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecogSheet((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("file_type")) {
      Object obj = map.get("file_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFileType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("data_status")) {
      Object obj = map.get("data_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDataStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("file_origin")) {
      Object obj = map.get("file_origin");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFileOrigin((String)obj);
        }
      } else {
      }
    }
  }
}
