package com.xforceplus.purchaserinvoicesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票类型
 * </p>
 *
 * @author ultraman
 * @since 2023-03-08
 */
public enum InvoiceType {

    SE("se", "增值税电子专用发票"),
    S("s", "增值税专用发票"),
    C("c", "增值税普通发票"),
    CE("ce", "增值税电子普通发票"),
    JU("ju", "增值税普通发票(卷票)"),
    CT("ct", "增值税电子普通发票(通行费)"),
    V("v", "机动车统一销售发票"),
    CB("cb", "区块链发票"),
    CD("cd", "通用(电子)发票"),
    VS("vs", "二手车销售统一发票"),
    QC("qc", "电子发票（普通发票）"),
    QS("qs", "电子发票（增值税专用发票）"),
    _0("0", "无"),
    CZ("cz", "纸质发票（普通发票）"),
    SZ("sz", "纸质发票（增值税专用发票）");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceType fromCode(String code){
        switch(code) {
            case "se":
                return SE;
            case "s":
                return S;
            case "c":
                return C;
            case "ce":
                return CE;
            case "ju":
                return JU;
            case "ct":
                return CT;
            case "v":
                return V;
            case "cb":
                return CB;
            case "cd":
                return CD;
            case "vs":
                return VS;
            case "qc":
                return QC;
            case "qs":
                return QS;
            case "0":
                return _0;
            case "cz":
                return CZ;
            case "sz":
                return SZ;
            default:
                return null;
        }
    }
}
