package com.xforceplus.purchaserinvoicesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发送的数据源
 * </p>
 *
 * @author ultraman
 * @since 2023-03-08
 */
public enum SendDataSource {

    _1("1", "验真来源"),
    _2("2", "底账来源"),
    _3("3", "协同直联"),
    _4("4", "协同抽取"),
    _5("5", "协同手工回填"),
    _6("6", "影像识别"),
    _7("7", "票税助手"),
    _8("8", "接口上传"),
    _9("9", "业务来源");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SendDataSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SendDataSource fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            default:
                return null;
        }
    }
}
