package com.xforceplus.purchaserinvoicesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 进转出类型
 * </p>
 *
 * @author ultraman
 * @since 2023-03-08
 */
public enum TurnOutType {

    _1("1", "免税项目用"),
    _2("2", "集体福利、个人消费"),
    _3("3", "非正常损失"),
    _4("4", "简易计税方法征税项目用"),
    _5("5", "免抵退税办法不得抵扣的进项税额"),
    _6("6", "纳税检查调减进项税额"),
    _7("7", "红字专用发票信息表注明的进项税额"),
    _8("8", "上期留抵税额抵减欠税"),
    _9("9", "上期留抵税额退税"),
    _10("10", "其他应作进项税额转出的情形"),
    _0("0", "无");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TurnOutType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TurnOutType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            case "10":
                return _10;
            case "0":
                return _0;
            default:
                return null;
        }
    }
}
