package com.xforceplus.purchaserordersaas.controller;


/**
 * 业务单主对象feign客户端
 *
 * @author ultraman
 * @date 2023-09-13
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.purchaserordersaas.entity.BizOrder;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-order-saas")
public interface BizOrderFeignApi {

  /**
   * 通过id查询业务单主对象
   * @param  id
   * @return R
   */
  @GetMapping("/bizOrder/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增业务单主对象
   * @param bizOrder 业务单主对象
   * @return R
   */
  @PostMapping("/bizOrder/add")
  public R save(@RequestBody BizOrder bizOrder);

  /**
   * 修改业务单主对象
   * @param bizOrder 业务单主对象
   * @return R
   */
  @PostMapping("/bizOrder/update")
  public R updateById(@RequestBody BizOrder bizOrder);

  /**
   * 通过id删除业务单主对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/bizOrder/del/{id}" )
  public R removeById(@PathVariable Long id);

}